(function (Drupal, once) {
  Drupal.behaviors.ajax_callback_field_formatter = {
    attach(context) {
      const elements = once('ajax_callback_field_formatter', '[data-execute-ajax-callback-field-formatter-id]', context);

      // `elements` is always an Array.
      elements.forEach(function (value, index) {
        const url = new URL(window.location.origin + value.getAttribute('data-execute-ajax-callback-field-formatter-url'));
        url.searchParams.set(
          'ajax_callback_field_formatter_id',
          '[data-execute-ajax-callback-field-formatter-id="' + value.getAttribute('data-execute-ajax-callback-field-formatter-id') + '"]'
        );

        Drupal.ajax({
          url: url.href,
          error: function (xhr) {
            console.log('AJAX error when requesting ' + url.href + ': "' + xhr.status + ' - ' + xhr.statusText + '"');
          }
        }).execute();
      });
    }
  };
}(Drupal, once));
