<?php

namespace Drupal\ajax_callback_field_formatter\Plugin\Field\FieldFormatter;

use Drupal\Core\Annotation\Translation;
use Drupal\Core\Field\Annotation\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Url;
use Drupal\link\Plugin\Field\FieldFormatter\LinkFormatter;

/**
 * @FieldFormatter(
 *   id = "ajax_callback_field_formatter",
 *   label = @Translation("Ajax Callback Formatter"),
 *   description = @Translation("Alter link type field to usr the url part as the url ajax callback and the text part as placeholder"),
 *   field_types = {"link"},
 * )
 */
class AjaxCallbackFieldFormatter extends LinkFormatter
{

  /**
   * {@inheritDoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode)
  {
    $elements = parent::viewElements($items, $langcode);

    $entity = $items->getEntity();
    $entityTypeId = str_replace('_', '-', $entity->getEntityTypeId());
    $entityId = $entity->id();
    $fieldName = str_replace('_', '-', $items->getFieldDefinition()->getName());

    $baseSelectorId = $entityTypeId . '--' . $entityId . '--' . $fieldName;

    foreach ($elements as $delta => $element) {
      /** @var Url $url */
      $url = $element['#url'];

      $elements[$delta] = [
        '#theme' => 'ajax_callback_field_formatter_template',
        '#title_value' => $element['#title'],
        '#element_attributes_url' => $url->toString(),
        '#element_attributes_id' => "$baseSelectorId--$delta",
      ];
    }

    $elements['#attached']['library'][] = 'ajax_callback_field_formatter/ajax_callback_field_formatter';

    return $elements;
  }
}
