<?php

namespace Drupal\ajax_dashboard\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Session\AccountInterface;

/**
 * Class AJAXDashboardControlBase.
 *
 * TODO Put control annotation into practice - we aren't using this yet.
 *
 * @package Drupal\ajax_dashboard\Plugin
 */
abstract class AJAXDashboardControlBase extends PluginBase implements AJAXDashboardControlInterface {

  /**
   * Determine access to control and content.
   *
   * @param array $params
   *   Associative array of parameters passed to control theme array.
   * @param array $control_data
   *   Associative array of control data provided from parent dashboard.
   * @param \Drupal\Core\Session\AccountInterface|null $account
   *   The user account for access checking. Set to NULL for current user.
   *
   * @return bool
   *   True if the user has access, false if not.
   */
  public static function access(array $params = [], array $control_data = [], AccountInterface $account = NULL) {
    $account = $account ? $account : \Drupal::currentUser();
    return TRUE;
  }


  /**
   * Get the content to display on the dashboard.
   *
   * @param array $params
   *   Associative array of parameters passed to the parent dashboard.
   * @param array $control_data
   *   Associative array of control data, including the ID of the dashboard
   *   and of the parent control.
   *
   * @return array
   *   Render array of dashboard content.
   */
  public static function getControlDashboardContent(array $params = [], array $control_data = []) {
    return ['#markup' => t('Dashboard')];
  }

  /**
   * Modify the AJAX response with extra commands, if needed for this control.
   *
   * @param AjaxResponse $response
   *   AJAX Response to modify.
   * @param array $params
   *   Associative array of parameters passed to the parent dashboard.
   * @param array $active_control
   *   The selected control from the controller.
   *
   * @return AjaxResponse $response
   *   The modified response.
   */
  public static function AddAJAXResponseCommands(AjaxResponse $response = NULL, array $params = [], array $active_control = []) {
    return $response;
  }

}
