<?php

namespace Drupal\ajax_dashboard_example\Plugin\AJAXDashboardControl;

use Drupal\ajax_dashboard\AJAXDashboard;
use Drupal\ajax_dashboard\Plugin\AJAXDashboardControl\ButtonList;
use Drupal\ajax_dashboard\Plugin\AJAXDashboardControlBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Class ProgrammaticControlExample.
 *
 * Example dashboard control showing hoe to programmatically generate buttons.
 *
 * @package Drupal\ajax_dashboard_example\Plugin\AJAXDashboardControl
 *
 * @AJAXDashboardControl (
 *   id = "programmatic_control_example",
 *   label = "Programmatic Control Example"
 * )
 */
class ProgrammaticControlExample extends AJAXDashboardControlBase {

  /**
   * {@inheritdoc}
   */
  public static function access(array $params = [], array $control_data = [], AccountInterface $account = NULL) {
    return parent::access($params, $control_data, $account); // TODO: Change the autogenerated stub
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonData(array $dashboard_params = [], array $control = [], array $dashboard = []) {
    $button_manager = \Drupal::service('plugin.manager.ajax_dashboard_button');
    $button_definitions = $button_manager->getDefinitions();

    $button_data = [
      'js_alert' => [
        'plugin' => 'ajax_dashboard_js_alert',
        'label' => t('Example: JS Alert'),
      ],
      'constant' => [
        'plugin' => 'constant',
        'label' => t('Programmatic Constant'),
        'constant' => '<h2>' . t('Programmatic Constant') . '</h2>' . '<p>' . t('Username of the Current User: ') . \Drupal::currentUser()->getDisplayName() . '</p>',
      ],
    ];
    foreach($button_data as $button_index => $button) {
      if (isset($button['plugin']) && isset($button_definitions[$button['plugin']])) {
        $button_plugin = $button_definitions[$button['plugin']];
        if ($button_plugin['class']::access($dashboard_params['params'], $button)) {
          $button_key_array = [
            $dashboard['id'],
            $control['id'],
            $button_index,
          ];
          $button_key = implode('_', $button_key_array);
          $buttons[$button_key] = $button_plugin;
          $buttons[$button_key]['button_data'] = $button;
          $buttons[$button_key]['button_data']['dashboard_id'] = $dashboard['id'];
          $buttons[$button_key]['button_data']['control_id'] = $control['id'];
          $buttons[$button_key]['button_data']['button_id'] = $button_index;
          $buttons[$button_key]['button_data']['params'] = $dashboard_params['params'];
        }
      }
    }

    return $buttons;
  }

  /**
   * @param array $variables
   */
  public static function buildControl(array &$variables) {
    parent::buildControl($variables);
    $dashboard_params = [
      'dashboard' => $variables['control']['#dashboard_id'],
      'params' => $variables['control']['#params'],
    ];
    $control = $variables['control']['#control_data'];
    $control['id'] = $variables['control']['#control_id'];
    // For the function call, we only need the ID.
    $dashboard = ['id' => $variables['control']['#dashboard_id']];
    $button_data = self::getButtonData($dashboard_params, $control, $dashboard);
    $variables['control']['#control_data']['buttons'] = $button_data;

    // Add the buttons.
    $variables['control']['buttons'] = [
      '#type' => 'html_tag',
      '#tag' => 'div',
    ];

    /*
     * Note that in Drupal\ajax_dashboard\Plugin\AJAXDashboardControl\ButtonList,
     * the button key is a constant from configuration.
     *
     * Here, it is the [dashboard_id]_[control_id]_[button_id], so we must specify
     * the button id from previously generated data. Otherwise, the dashboard
     * will not render.
     */
    foreach ($button_data as $button_key => $button) {
      if (strpos($button_key, '#') === 0) {
        $variables['control']['buttons'][$button_key] = $button;
      }
      else {
        $variables['control']['buttons'][$button_key] = [
          '#theme' => 'ajax_dashboard_button',
          '#dashboard_id' => $variables['control']['#dashboard_id'],
          '#control_id' => $variables['control']['#control_id'],
          '#button_id' => $button['button_data']['button_id'],
          '#button_data' => $button['button_data'],
          '#params' => $variables['control']['#params'],
          '#weight' => isset($button['weight']) ? $button['weight'] : 0,
        ];
      }
    }
    $variables['control']['buttons']['#attributes']['class'][] = 'ajax-dashboard-buttons';
  }

}
