<?php

namespace Drupal\ajax_dashboard_example\Plugin\AJAXDashboardSection;

use Drupal\ajax_dashboard\Plugin\AJAXDashboardSectionBase;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Form\FormStateInterface;
use Drupal\js_ajax_test\Ajax\JsAjaxTestCommand;

/**
 * Class AJAXDashboardExample
 * @package Drupal\ajax_dashboard_example\Plugin\AJAXDashboardSection
 *
 * @AJAXDashboardSection (
 *   id = "ajax_dashboard_example",
 *   label = "AJAX Dashboard Example"
 * )
 *
 */
class AJAXDashboardExample extends AJAXDashboardSectionBase {

  /**
   * @param $form
   * @param FormStateInterface $form_state
   * @param null $request
   * @return array|AjaxResponse|mixed
   */
  public static function buildDashboard($form, FormStateInterface $form_state, $request = NULL) {
    if ($trigger =$form_state->getTriggeringElement()) {
      $add = [
        [
          '#type' => 'html_tag',
          '#tag' => 'h4',
          '#prefix' => '<div id="edit-dashboard" class="dashboard-wrapper">',
        ]
      ];
      switch ($trigger['#id']) {
        case 'ajax_dashboard_example_button':
          $add[0]['#value'] = t('You pressed the first button');
        break;
        case 'ajax_dashboard_example_button_2':
          $add[0]['#value'] = t('You pressed the second button');
        break;
      }
      $add[] = [
        '#type' => 'html_tag',
        '#tag' => 'p',
        '#value' => t('Look at ajax_dashboard/src/Plugin/AJAXDashboardSection/AJAXDashboardExample.php for an example of how to create an AJAX Dashboard plugin.'),
        '#suffix' => '</div>',
      ];
      $response = new AjaxResponse();
      $response->addCommand(new ReplaceCommand('#edit-dashboard', $add));
      return $response;
    }
    else {
      return [
        [
          '#type' => 'html_tag',
          '#tag' => 'h3',
          '#value' => t('AJAX Dashboard Example')
        ],
        [
          '#type' => 'html_tag',
          '#tag' => 'p',
          '#value' => t('Look at ajax_dashboard/src/Plugin/AJAXDashboardSection/AJAXDashboardExample.php for an example of how to create an AJAX Dashboard plugin.')
        ],
      ];
    }

  }

  /**
   * @param $form
   * @param FormStateInterface $form_state
   * @param array $context
   * @param array $params
   * @return array|mixed
   */
  public static function buildSection($form, FormStateInterface $form_state, array $context = [], array $params = []) {
    $section = [
        '#type' => 'html_tag',
        '#tag' => 'h3',
        '#value' => t('Example Content')
    ];
    $button = [
      '#type' => 'button',
      '#value' => 'Button',
      '#id' => 'ajax_dashboard_example_button',
      '#ajax' => [
        'callback' => 'Drupal\ajax_dashboard\Plugin\AJAXDashboardSection\AJAXDashboardExample::buildDashboard',
        'event' => 'click',
        'wrapper' => 'edit-dashboard',
      ],
    ];
    $button_2 = [
      '#type' => 'button',
      '#value' => 'Second Button',
      '#id' => 'ajax_dashboard_example_button_2',
      '#ajax' => [
        'callback' => 'Drupal\ajax_dashboard\Plugin\AJAXDashboardSection\AJAXDashboardExample::buildDashboard',
        'event' => 'click',
        'wrapper' => 'edit-dashboard',
      ],
    ];

    return [
      'ajax_dashboard_example_section' => $section,
      'ajax_dashboard_example_button' => $button,
      'ajax_dashboard_example_button_2' => $button_2,
    ];
  }

}