(function ($, Drupal) {
  // source: https://stackoverflow.com/questions/5999118/how-can-i-add-or-update-a-query-string-parameter
  function updateQueryStringParameter(uri, key, value) {
    var re = new RegExp("([?&])" + key + "=.*?(&|$)", "i");
    var separator = uri.indexOf('?') !== -1 ? "&" : "?";
    if (uri.match(re)) {
      return uri.replace(re, '$1' + key + "=" + value + '$2');
    }
    else {
      return uri + separator + key + "=" + value;
    }
  }

  Drupal.behaviors.ajaxDashboard = {
    attach: function (context, settings) {
      console.log(settings.ajax_dashboard.dashboard_id);
      $('.ajax-dashboard-button button').click(function () {
        $(this).parents('.ajax-dashboard-button').each(function() {
          // First, set the URL
          var section_key = $(this).attr('data-ajax-dashboard-key');
          qstring = updateQueryStringParameter(window.location.search, 'dashboard', section_key);
          u = window.location.pathname + qstring;
          history.pushState({}, "", u);
          // Now, set a cookie to remember the form someone looked at previously.
          document.cookie = 'ajax_dashboard__' + settings.ajax_dashboard.dashboard_id + "=" + section_key + ";path=/";
        });
      });
    }
  };
})(jQuery, Drupal);
