<?php

namespace Drupal\ajax_dashboard\Plugin\AJAXDashboardSection;

use Drupal\ajax_dashboard\Plugin\AJAXDashboardSectionBase;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class AJAXDashboardExample
 * @package Drupal\ajax_dashboard_example\Plugin\AJAXDashboardSection
 *
 * @AJAXDashboardSection (
 *   id = "ajax_dashboard_constant",
 *   label = "AJAX Dashboard Constant"
 * )
 *
 */
class AJAXDashboardConstant extends AJAXDashboardSectionBase {

  /**
   * @param $form
   * @param FormStateInterface $form_state
   * @param null $request
   * @param array $params
   * @return array|AjaxResponse|mixed
   */
  public static function buildDashboard($form, FormStateInterface $form_state, $request = NULL, $params = []) {
    if ($trigger =$form_state->getTriggeringElement()) {
      $add = [
        '#type' => 'html_tag',
        '#tag' => 'h4',
        '#prefix' => '<div id="edit-dashboard" class="dashboard-wrapper">',
        '#suffix' => '</div>',
      ];
      $add['#value'] = $trigger['#content_data'];
      $response = new AjaxResponse();
      $response->addCommand(new ReplaceCommand('#edit-dashboard', $add));
      return $response;
    }
    else {
      return [
        '#type' => 'html_tag',
        '#tag' => 'h3',
        '#value' => $params['button']['content']
      ];
    }

  }

  /**
   * @param $form
   * @param FormStateInterface $form_state
   * @param array $context
   * @param array $params
   * @return array|mixed
   */
  public static function buildSection($form, FormStateInterface $form_state, array $context = [], array $params = []) {
    $section = [
      '#type' => 'html_tag',
      '#tag' => 'h3',
      '#value' => $params['label']
    ];
    $button = [
      '#type' => 'button',
      '#value' => $params['button']['label'],
      '#id' => $params['button']['id'],
      '#content_data' => $params['button']['content'],
      '#ajax' => [
        'callback' => 'Drupal\ajax_dashboard\Plugin\AJAXDashboardSection\AJAXDashboardConstant::buildDashboard',
        'event' => 'click',
        'wrapper' => 'edit-dashboard',
      ],
    ];

    return [
      'ajax_dashboard_constant_section' => $section,
      'ajax_dashboard_constant' => $button
    ];
  }

}
