<?php

namespace Drupal\ajax_dashboard;

class AJAXDashboardControl {

  public static function buildControl(array &$variables) {
    $control_data = $variables['control']['#control_data'];
    $attributes = array_filter($control_data, function($k) {return strpos($k, '#') !== FALSE;}, ARRAY_FILTER_USE_KEY);
    foreach ($attributes as $key => $value) {
      if ($key === '#attributes') {
        foreach ($value as $attr_key => $attr) {
          $variables['attributes'][$attr_key] = $attr;
        }
      }
      else {
        $variables[$key] = $value;
      }
    }
    $variables['attributes']['class'][] = "ajax-dashboard-control";
    $variables['attributes']['id'] = "ajax-dashboard-control--" . $variables['control']['#dashboard_id'] . '--' . $variables['control']['#control_id'];
    $variables['control']['label'] = isset($control_data['label']) ? $control_data['label'] : '';

    // Add the buttons
    $variables['control']['buttons'] = [
      '#type' => 'html_tag',
      '#tag' => 'div',
    ];
    foreach ($control_data['buttons'] as $button_key => $button) {
      if (strpos($button_key,'#') === 0) {
        $variables['control']['buttons'][$button_key] = $button;
      }
      else {
        $variables['control']['buttons'][$button_key] = [
          '#theme' => 'ajax_dashboard_button',
          '#dashboard_id' => $variables['control']['#dashboard_id'],
          '#control_id' => $variables['control']['#control_id'],
          '#button_id' => $button_key,
          '#button_data' => $button,
          '#params' => $variables['control']['#params'],
          '#weight' => isset($button['weight']) ? $button['weight'] : 0
        ];
      }
    }
    $variables['control']['buttons']['#attributes']['class'][] = 'ajax-dashboard-buttons';
  }

}