<?php

namespace Drupal\ajax_dashboard\Controller;

use Drupal\ajax_dashboard\AJAXDashboard;
use Drupal\Component\Utility\Html;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\ReplaceCommand;
use Drupal\Core\Controller\ControllerBase;

class AJAXDashboardController extends ControllerBase {

  public function loadDashboard() {
    $query = \Drupal::request()->query;
    $params = [];
    foreach ($query->all() as $key => $value) {
      if (strpos($key, 'param__') !== FALSE) {
        $k = str_replace('param__', '', $key);
        $params['params'][$k] = $value;
      }
      else {
        $params[$key] = $value;
      }
    }
    $build = AJAXDashboard::displayDashboard($params);
    $response = new AjaxResponse();
    $dashboard_id = Html::escape($params['dashboard']);
    $replace = new ReplaceCommand('#ajax-dashboard-display--' . $dashboard_id, $build);

    $response->addCommand($replace);
    return $response;
  }

  public function loadDashboardPlaceholder() {
    $query = \Drupal::request()->query;
    $dashboard_id = Html::escape($query->get('dashboard'));
    $build = [
      '#markup' => 'loading...',
      '#prefix' => '<div id="ajax-dashboard-display--' . $dashboard_id . '" class="ajax-dashboard-display">',
      '#suffix' => '</div>',
      '#cache' => ['max-age' => 0]
    ];
    $response = new AjaxResponse();
    $replace = new ReplaceCommand('#ajax-dashboard-display--' . $dashboard_id, $build);

    $response->addCommand($replace);
    return $response;
  }

}