<?php

namespace Drupal\ajax_dashboard\Plugin\AJAXDashboardButton;

use Drupal\ajax_dashboard\Plugin\AJAXDashboardButtonBase;

/**
 * Class Constant
 * @package Drupal\ajax_dashboard_example\Plugin\AJAXDashboardSection
 *
 * @AJAXDashboardButton (
 *   id = "route",
 *   label = "load a route into the dashbaord."
 * )
 *
 */
class Route extends AJAXDashboardButtonBase {

  /**
   * {@inheritdoc}
   */
  public static function access($params = [], $button_data = [], $account = NULL) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonStatus($params = [], $button_data = []) {
    return 'neutral';
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonLabel($params = [], $button_data = []) {
    return parent::getButtonLabel($params, $button_data);
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonDashboardContent($params = [], $button_data = []) {
    if (isset($button_data['constant'])) {
      return ['#markup' => t($button_data['constant'])];
    }
    return ['#markup' => ''];
  }

}
