<?php

namespace Drupal\ajax_dashboard_views\Plugin\AJAXDashboardButton;

use Drupal\ajax_dashboard\Plugin\AJAXDashboardButtonBase;
use Drupal\views\Views;

/**
 * Class View
 * @package Drupal\ajax_dashboard_example\Plugin\AJAXDashboardSection
 *
 * @AJAXDashboardButton (
 *   id = "view",
 *   label = "AJAX Dashboard View"
 * )
 *
 */
class View extends AJAXDashboardButtonBase {

  public static function viewData($button_data) {
    return [
      'view' => $button_data['view'],
      'display' => isset($button_data['display']) ? $button_data['display'] : 'default'
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function access($params = [], $button_data = [], $account = []) {
    $view_data = self::viewData($button_data);
    $view = Views::getView($view_data['view']);
    return $view->access($view_data['display']);
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonStatus($params = [], $button_data = []) {
    return 'neutral';
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonLabel($params = [], $button_data = []) {
    return parent::getButtonLabel($params, $button_data);
  }

  /**
   * {@inheritdoc}
   */
  public static function getButtonDashboardContent($params = [], $button_data = []) {
    $view_data = self::viewData($button_data);
    $view = Views::getView($view_data['view']);
    $view->setDisplay($view_data['display']);
    $args = [];
    if ($button_data['args']) {
      foreach ($button_data['args'] as $arg) {
        if (isset($params[$arg])) {
          $args[] = $params[$arg];
        }
      }
    }
    if (!empty($args)) {
      $view->setArguments($args);
    }
    return $view->preview();
  }

}
