<?php

namespace Drupal\ajax_dashboard\Plugin;

use Drupal\Component\Plugin\PluginBase;

/**
 * Base class for AJAX Dashboard Button plugins.
 */
abstract class AJAXDashboardButtonBase extends PluginBase implements AJAXDashboardButtonInterface {

  /**
   * @param array $params
   * @return bool
   */
  public static function access($params = [], $button_data = [], $account = NULL) {
    return TRUE;
  }

  /**
   * @param array $params
   * @return string
   */
  public static function getButtonStatus($params = [], $button_data = []) {
    return 'neutral';
  }

  /**
   * Get the button's status text.
   *
   * The button status is a span with a status class and status text.
   * This function generates the status text.
   * @param array $params
   *   Associative array of parameters passed to the parent dashboard.
   * @param array $button_data
   *   Associative array of button data, including the ID of the dashboard
   *   and of the parent control.
   * @return mixed
   *   String or Translatable Markup which is placed into a span tag.
   */
  public static function getButtonStatusText($params = [], $button_data = []) {
    return '';
  }

  /**
   * Generate the button label.
   * @param array $params
   *   Associative array of parameters passed to the parent dashboard.
   * @param array $button_data
   *   Associative array of button data, including the ID of the dashboard
   *   and of the parent control.
   * @return mixed
   *   String or Translatable Markup which is placed into a span tag.
   */
  public static function getButtonLabel($params = [], $button_data = []) {
    if (isset($button_data['label'])) {
      return $button_data['label'];
    }
    else {
      return t('Button');
    }
  }

  /**
   * @param array $params
   * @param array $button_data
   * @return array
   */
  public static function getButtonDashboardContent($params = [], $button_data = []) {
    return ['#markup' => t('Dashboard')];
  }

}
