<?php

namespace Drupal\ajaxform\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

class ajax extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ajax';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    // Textfield with a single AJAX callback that will trigger multiple functions.
    $form['textfield'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Enter some text'),
      '#ajax' => [
        'callback' => '::combinedAjaxCallback',
        'wrapper' => 'ajax-wrapper',
        'event' => 'input', // Trigger on change event
      ],
    ];

    // A wrapper for elements that will be updated via AJAX.
    $form['ajax_wrapper'] = [
      '#type' => 'container',
      '#attributes' => ['id' => 'ajax-wrapper'],
    ];

    // Label that gets updated.
    $form['ajax_wrapper']['label'] = [
      '#markup' => '<div>' . $this->t('Current text: ') . '</div>',
    ];

    // Message that gets updated.
    $form['ajax_wrapper']['message'] = [
      '#markup' => '<div>' . $this->t('Message will appear here.') . '</div>',
    ];

    return $form;
  }

  /**
   * Combined AJAX callback function.
   */
  public function combinedAjaxCallback(array &$form, FormStateInterface $form_state) {
    // Call the first function to update the label.
    $form = $this->updateLabel($form, $form_state);

    // Call the second function to display a message.
    $form = $this->displayMessage($form, $form_state);

    // Return the wrapper containing all updated elements.
    return $form['ajax_wrapper'];
  }

  /**
   * Function to update the label.
   */
  public function updateLabel(array &$form, FormStateInterface $form_state) {
    $input_value = $form_state->getValue('textfield');
    $form['ajax_wrapper']['label']['#markup'] = '<div>' . $this->t('Current text: @text', ['@text' => $input_value]) . '</div>';
    return $form;
  }

  /**
   * Function to display a message.
   */
  public function displayMessage(array &$form, FormStateInterface $form_state) {
    $input_value = $form_state->getValue('textfield');

    if (!empty($input_value)) {
      $form['ajax_wrapper']['message']['#markup'] = '<div>' . $this->t('You have entered: @value', ['@value' => $input_value]) . '</div>';
    } else {
      $form['ajax_wrapper']['message']['#markup'] = '<div>' . $this->t('Please enter some text.') . '</div>';
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Submit handler if needed.
  }
}
