(function ($, Drupal) {
    Drupal.behaviors.ajaxParagraphs = {
      attach: function (context, settings) {
        $('.ajax-paragraph-placeholder', context).once('ajaxParagraphs').each(function () {
          const placeholder = $(this);
          const entityId = placeholder.data('entity-id');
          const fieldName = placeholder.data('field-name');
  
          $.ajax({
            url: `/ajax/paragraphs/${entityId}/${fieldName}`,
            method: 'GET',
            success: function (response) {
              placeholder.replaceWith(response);
            },
            error: function () {
              placeholder.text('Error during paragraphs loading.');
            },
          });
        });
      }
    };
  })(jQuery, Drupal);
  