<?php

namespace Drupal\ajax_paragraphs\Controller;


use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\JsonResponse;

class AjaxParagraphsController extends ControllerBase {


  public function loadParagraphs($entity_id, $field_name) {
    $node = \Drupal::entityTypeManager()->getStorage('node')->load($entity_id); // TODO : not only node

    if ($node && $node->hasField($field_name)) {
      $field = $node->get($field_name);
      $paragraphs = $field->referencedEntities();
      $rendered_paragraphs = [];

    foreach ($paragraphs as $paragraph) {
        $render_array = \Drupal::entityTypeManager()
        ->getViewBuilder('paragraph')
        ->view($paragraph);

        $rendered_paragraphs[] = \Drupal::service('renderer')->render($render_array);
    }

      return new JsonResponse(implode('', $rendered_paragraphs));
    }

    return new JsonResponse('Field or node not found', 404);
  }

}
