(function($) {
  var unblock;
  $(document).ajaxSend(function(event, jqxhr, settings) {
    unblock = false;
    var target = settings.url;
    var pages = Drupal.settings.ajax_screen_lock.pages;
    var visibility = Drupal.settings.ajax_screen_lock.visibility;
    var throbber_hide = Drupal.settings.ajax_screen_lock.throbber_hide;
    var disabled = Drupal.settings.ajax_screen_lock.disabled;
    var blockui = function () {
      $.blockUI({
        message: Drupal.settings.ajax_screen_lock.message,
        css: {
          top: ($(window).height() - 400) / 2 + 'px',
          left: ($(window).width() - 400) / 2 + 'px',
          width: '400px'
        },
        timeout: Drupal.settings.ajax_screen_lock.timeout,
        onBlock: function () {
          unblock = true;
          if (throbber_hide) {
            $('.ajax-progress-throbber').hide();
          }
        }
      });
    }

    // If is not disabled.
    if (!disabled) {
      if (!$.isEmptyObject(pages)) {
        // Handle pages.
        $.each(pages, function (num, page) {
          if (target.length >= page.trim().length) {
            if (target.substr(0, page.trim().length) == page.trim() && visibility == 1) {
              blockui();
            }
            else if (visibility == 0 && target.substr(0, page.trim().length) != page.trim()) {
              blockui();
            }
          }
        });
      }
      else {
        blockui();
      }
    }
  });

  $(document).ajaxStop(function(r, s) {
    if (unblock) {
      $.unblockUI();
    }
  });
}(jQuery));