(function ($, Drupal) {

  /**
   * Store content in history command.
   *
   * @param {Drupal.Ajax} [ajax]
   *   A {@link Drupal.ajax} object.
   * @param {object} response
   *   Ajax response.
   * @param {string} response.selector
   *   Selector to use.
   * @param {array} response.data
   *   Data to store.
   */
  Drupal.AjaxCommands.prototype.storeHistory = function (ajax, response) {
    if (!!window.history || !!window.history.pushState) {
      var content = $(response.selector).html();
      var path = response.path;
      window.history.pushState({'selector': response.selector, 'content': content}, '', path);
    }
  };

})(jQuery, Drupal);
