/**
 * @file
 * Provides Ajaxin functionality for Drupal AJAX.
 */

(function (Drupal, drupalSettings, _db, window, document) {

  'use strict';

  var _ajax = Drupal.Ajax || {};
  var _proto = _ajax.prototype;
  var _doc = document.documentElement || document.body;
  var _ajaxTimer;

  /**
   * Overrides Drupal.Ajax.prototype.success event.
   */
  _proto.success = (function (_ajax) {
    return function (response, status) {
      var me = this;
      var el;
      var cn;

      if (me.progress && me.progress.element && me.progress.type === 'fullscreen') {
        el = typeof me.progress.element.length !== 'undefined' ? me.progress.element[0] : me.progress.element;

        if (el !== null && el !== 'undefined' && el.classList.contains('ajaxin-wrapper--fs')) {
          // Impresses a graceful completion as otherwise abrupt.
          document.body.insertAdjacentHTML('beforeend', Drupal.theme('ajaxProgressIndicatorFullscreen'));

          // Cleans up the progressbar.
          _doc.classList.add('is-ajaxin--done');

          window.clearTimeout(_ajaxTimer);
          _ajaxTimer = window.setTimeout(function () {
            _doc.classList.remove('is-ajaxin');
            _doc.classList.remove('is-ajaxin--done');
            cn = _doc.querySelector('.ajaxin-wrapper--fs');
            if (cn !== null) {
              cn.parentNode.removeChild(cn);
            }
          }, 800);
        }
      }

      return _ajax.apply(this, arguments);
    };
  })(_proto.success);

  /**
   * Overrides Drupal.Ajax.prototype.setProgressIndicatorFullscreen.
   */
  var _fs = _proto.setProgressIndicatorFullscreen;
  _proto.setProgressIndicatorFullscreen = function () {
    _doc.classList.add('is-ajaxin');
    _fs.call(this);
  };

  // Overrides Drupal.theme.ajaxProgressIndicatorFullscreen().
  Drupal.theme.ajaxProgressIndicatorFullscreen = function () {
    var settings = drupalSettings.ajaxin || {};
    settings.fs = true;
    return Drupal.theme.ajaxin(settings);
  };

  // Overrides Drupal.theme.ajaxProgressThrobber().
  Drupal.theme.ajaxProgressThrobber = function (message) {
    var messageMarkup = typeof message === 'string' ? Drupal.theme('ajaxProgressMessage', message) : '';
    var settings = drupalSettings.ajaxin || {};
    settings.fs = false;
    var throbber = Drupal.theme.ajaxin(settings);

    return '<div class="ajax-progress ajax-progress-throbber ajax-progress--ajaxin">' + throbber + messageMarkup + '</div>';
  };

})(Drupal, drupalSettings, dBlazy, this, this.document);
