<?php

namespace Drupal\ajaxin;

use Drupal\blazy\BlazyManagerBase;

/**
 * Provides Ajaxin utility.
 */
class Ajaxin extends BlazyManagerBase implements AjaxinInterface {

  /**
   * The available skins.
   *
   * @var array
   */
  protected $skins;

  /**
   * The JS config.
   *
   * @var array
   */
  protected $jsConfig;

  /**
   * The library info definition.
   *
   * @var array
   */
  protected $libraryInfoBuild;

  /**
   * Checks if the library is attached.
   *
   * @var bool
   */
  protected $pageAttachments = FALSE;

  /**
   * {@inheritdoc}
   */
  public function getSkins() {
    if (!isset($this->skins)) {
      $skins = [
        'chasing-dots'    => 2,
        'circle'          => 12,
        'cube-grid'       => 9,
        'double-bounce'   => 2,
        'fading-circle'   => 12,
        'pulse'           => 0,
        'rotating-plane'  => 0,
        'three-bounce'    => 3,
        'wandering-cubes' => 2,
        'wave'            => 5,
        'wordpress'       => 1,
      ];

      $this->getModulehandler()->alter('ajaxin_skins', $skins);
      $this->skins = $skins;
    }

    return $this->skins;
  }

  /**
   * {@inheritdoc}
   */
  public function jsConfig() {
    if (!isset($this->jsConfig)) {
      $config = $this->configLoad('', 'ajaxin.settings');
      $config['count'] = 0;
      if ($skin = $config['skin']) {
        $config['count'] = $this->getSkins()[$skin];

        // Provides the inline Ajaxin theme.
        $template = ['#theme' => 'ajaxin'];
        $config['theme'] = $this->getRenderer()->renderPlain($template);

        // Provides the full screen Ajaxin theme.
        $template = ['#theme' => 'ajaxin', '#fs' => TRUE];
        $config['themeFullscreen'] = $this->getRenderer()->renderPlain($template);
      }
      $this->jsConfig = $config;
    }

    return $this->jsConfig;
  }

  /**
   * Implements hook_library_info_build().
   */
  public function libraryInfoBuild() {
    if (!isset($this->libraryInfoBuild)) {
      $libraries = [];
      foreach ($this->getSkins() as $skin => $count) {
        $libraries[$skin]['css']['component']['css/components/ajaxin.' . $skin . '.css'] = [];
        $libraries[$skin]['dependencies'][] = 'ajaxin/ajaxin';
      }
      $this->libraryInfoBuild = $libraries;
    }

    return $this->libraryInfoBuild;
  }

  /**
   * Implements hook_library_info_alter().
   */
  public function libraryInfoAlter(array &$libraries, $module) {
    // Adds our ajaxin to drupal.ajax or blazy.load for a custom progressbar.
    $ajax = $module === 'core' && isset($libraries['drupal.ajax']);
    $blazy = $module === 'blazy' && isset($libraries['load']);
    $path = drupal_get_path('module', 'ajaxin');

    if ($ajax) {
      $libraries['drupal.ajax']['js']['/' . $path . '/js/ajaxin.ajax.min.js'] = ['minified' => TRUE];
    }

    if ($blazy) {
      $libraries['load']['js']['/' . $path . '/js/ajaxin.blazy.min.js'] = ['minified' => TRUE];
    }

    if ($ajax || $blazy) {
      $item = $blazy ? 'load' : 'drupal.ajax';
      $config = $this->jsConfig();

      $libraries[$item]['dependencies'][] = 'ajaxin/ajaxin';
      if (!$this->configLoad('sitewide', 'ajaxin.settings')) {
        $libraries[$item]['dependencies'][] = 'ajaxin/' . $config['skin'];
        $libraries[$item]['drupalSettings']['ajaxin'] = $config;
      }
    }
  }

  /**
   * Implements hook_page_attachments().
   */
  public function pageAttachments(array &$page) {
    if (!$this->pageAttachments) {
      $config = $this->jsConfig();
      if (!empty($config['sitewide'])) {
        $page['#attached']['library'][] = 'ajaxin/' . $config['skin'];
        $page['#attached']['drupalSettings']['ajaxin'] = $config;
      }
      $this->pageAttachments = TRUE;
    }
  }

}
