/**
 * @file
  * Provides Ajaxin functionality to replace Blazy loading animation.
 */

(function (Drupal, drupalSettings, _db) {

  'use strict';

  Drupal.blazy = Drupal.blazy || {};

  /**
   * Attaches blazy behavior to HTML element identified by [data-blazy].
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.ajaxinBlazy = {
    attach: function (context) {
      var init = Drupal.blazy.init || null;
      var opts = Drupal.blazy.options || Drupal.blazy.globals() || {};

      // Merge existing options, including those of bLazy and Bio libraries.
      if (init !== null && init.options) {
        opts = _db.extend({}, init.options, opts);
      }

      // Adds the loading animation during page load.
      opts.addNow = true;

      opts.oldLoadingClass = 'media--loading';

      // Provides event which should trigger the removal of the preloader.
      // Ajaxin needs to know when to remove its own loading animation.
      opts.doneListener = 'blazy.done';

      // Initializes the Ajaxin.
      new Ajaxin(opts);
    }
  };

}(Drupal, drupalSettings, dBlazy));
