<?php

namespace Drupal\Tests\akamai\Unit\Helper;

use Drupal\akamai\Helper\CacheTagFormatter;
use Drupal\Tests\UnitTestCase;

/**
 * CacheTagFormatter tests.
 *
 * @group Akamai
 */
class CacheTagFormatterTest extends UnitTestCase {

  /**
   * Get a mock config factory.
   */
  public function getConfigFactory($tagPrefix = null) {
    $config = $tagPrefix ? ['edge_cache_tag_header_prefix' => $tagPrefix] : [];
    return $this->getConfigFactoryStub(['akamai.settings' => $config]);
  }

  /**
   * Tests format().
   *
   * @dataProvider tagTestCases
   */
  public function testFormat($input, $expected) {
    // Config with no prefix.
    $config = $this->getConfigFactory();
    $helper = new CacheTagFormatter($config);
    $this->assertSame($helper->format($input), $expected);

    // Config with prefix set to "prefix".
    $config = $this->getConfigFactory('prefix');
    $helper = new CacheTagFormatter($config);
    $this->assertSame($helper->format($input), 'prefix'.$expected);
  }

  /**
   * Provides tag testcase data.
   */
  public static function tagTestCases() {
    return [
      [1, '1'],
      ['node:1234', 'node_1234'],
      ['node 1234', 'node_1234'],
    ];
  }

}
