<?php

namespace Drupal\akamai_image_manager;

use Drupal\akamai_image_manager\Annotation\AimImageEffect;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Class AimImageEffectPluginManager.
 *
 * @package Drupal\cl_search
 */
class AimImageEffectPluginManager extends DefaultPluginManager {

  /**
   * Creates the discovery object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {

    $subdir = 'Plugin/AimImageEffect';

    $plugin_interface = AimImageEffectInterface::class;

    $plugin_definition_annotation_name = AimImageEffect::class;

    parent::__construct($subdir, $namespaces, $module_handler, $plugin_interface, $plugin_definition_annotation_name);

    $this->alterInfo('aim_image_effect_info');

    $this->setCacheBackend($cache_backend, 'aim_image_effect_info', ['aim_image_effect_info']);
  }

}
