# Akismet

Used by millions of websites, [Akismet](https://akismet.com) filters out hundreds of millions of spam
comments from the Web every day. Add Akismet to your site so you don't have to
worry about spam again.

Although it is best known from the WordPress world, Akismet is a web service
and can be used from any system to check content for spamminess. With this
module, you can use it to filter comments on your Drupal site.

For a full description of the module, visit the
[project page](http://drupal.org/project/akismet).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](http://drupal.org/project/issues/akismet).


## Table of contents

- Requirements
- Installation
- Configuration
- Testing
- Troubleshooting
- Maintainers


## Requirements

* This module requires an active subscription for the Akismet web service. In case of personal, non-commercial sites,
  Akismet offers a free tier. In other situations, you will need to pay. See
  [Akismet pricing](https://akismet.com/plans) for details. Note that the maintainer is in no way affiliated with
  the commercial Akismet service.
* This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

First, you need to configure your Akismet API key:

1. Go to Administration » Configuration » Content authoring
   » Akismet content moderation
2. Go to Settings
3. Fill in your Akismet API key and click *Save configuration*

The Akismet protection needs to be enabled and configured separately for each
form that you want to protect with Akismet:

1. Go to Administration » Configuration » Content authoring
   » Akismet content moderation
2. Add a form to protect and configure the options as desired.

Note the "bypass permissions" for each protected form:  If the currently
logged-in user has any of the listed permissions, then Akismet is NOT involved
in the form submission (at all).


## Testing

You may test Akismet without too much risk. In order to simulate a positive
(spam) result, set the comment author to "viagra-test-123" or comment author
email to "akismet-guaranteed-spam@example.com". For further details,
refer
[Akismet API documentation](https://akismet.com/development/api/#detailed-docs).

## Troubleshooting

For more info, please check [Akismet Docs](https://docs.akismet.com/)

## Maintainers

### Current Maintainers

- Eelke Blok - [eelkeblok](http://drupal.org/u/eelkeblok)

### Past Maintainers

- Jeff Eaton - [eaton](http://drupal.org/u/eaton)
- Katherine Senzee - [ksenzee](http://drupal.org/u/ksenzee)
- timmillwood - [timmillwood](http://drupal.org/u/timmillwood)
- andrew morton - [drewish](http://drupal.org/u/drewish)
