<?php

namespace Drupal\akismet_test_server;

use Drupal\Core\Url;
use Drupal\akismet\Client\DrupalClient;

/**
 * Class OAuthRequestParser.
 *
 * Parse OAuth requests?
 *
 * @todo Assess whether this is still needed.
 *
 * @package Drupal\akismet_test_server
 */
class OAuthRequestParser {

  /**
   * Returns whether the OAuth request signature is valid.
   *
   * @param array $sites
   *   An array of valid sites for this client keyed by public key.
   *
   * @return bool
   *   TRUE if a valid signature, FALSE if invalid.
   */
  public function validateOAuth($sites = []) {
    $data = self::getRestParameters();
    $header = self::getRestOAuthHeader();

    // Validate the timestamp.
    $client_time = $header['oauth_timestamp'];
    $time = \Drupal::time()->getRequestTime();
    $offset = abs($time - $client_time);
    if ($offset > DrupalClient::TIME_OFFSET_MAX) {
      return FALSE;
    }

    $sent_signature = $header['oauth_signature'];
    unset($header['oauth_signature']);

    $url = Url::fromRoute('<current>', [], ['absolute' => TRUE]);
    $base_string = implode('&', [
      $_SERVER['REQUEST_METHOD'],
      rawurlencode($url->toString()),
      rawurlencode(DrupalClient::httpBuildQuery($data + $header)),
    ]);

    if (!isset($sites[$header['oauth_consumer_key']]['privateKey'])) {
      return FALSE;
    }
    $privateKey = $sites[$header['oauth_consumer_key']]['privateKey'];
    $key = rawurlencode($privateKey) . '&';

    $signature = rawurlencode(base64_encode(hash_hmac('sha1', $base_string, $key, TRUE)));

    return $signature === $sent_signature;
  }

  /**
   * Returns HTTP request query parameters for the current request.
   *
   * @see DrupalClient::getServerParameters()
   * @return array
   *   The parameters passed to the request
   */
  public function getRestParameters() {
    $data = &drupal_static(__FUNCTION__);

    if (isset($data)) {
      return $data;
    }

    return DrupalClient::getServerParameters();
  }

  /**
   * Returns the parsed HTTP Authorization request header as an array.
   *
   * @return array
   *   The authentication header
   *
   * @see DrupalClient::getServerAuthentication()
   */
  public function getRestOAuthHeader() {
    $header = &drupal_static(__FUNCTION__);

    if (isset($header)) {
      return $header;
    }

    return DrupalClient::getServerAuthentication();
  }

}
