/**
 * @file
 * Alert message read.
 */
(function (Drupal, Cookie) {

  'use strict';

  Drupal.behaviors.alert_message_read = {
    attach: function (context, settings) {
      if (context.id.indexOf('block-alertmessage') === -1) {
        return;
      }
      // Set message as read in cookie.
      const messageCloseButtons = document.querySelectorAll('.alert-message-close');
      messageCloseButtons.forEach((button) => {
        button.addEventListener("click", function() {
          const messageId = this.getAttribute('data-message-id');
          let data = [];
          let cookie = Cookie.get('alertMessageClosed');
          if (typeof cookie === "string") {
            data = JSON.parse(cookie);
          }
          data.push(messageId);
          Cookie.set('alertMessageClosed', JSON.stringify(data));
          const message = document.getElementById('alert-message-' + messageId);
          message.remove();
        }, {'once': true});
      });

    }
  }
})(Drupal, window.Cookies);
