<?php

namespace Drupal\alert_message\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that the unpublish date is not earlier to publish one.
 *
 * @package alert_message
 */
class AlertMessagePublishDatesConstraintValidator extends ConstraintValidator {

  /**
   * {@inheritdoc}
   */
  public function validate($items, Constraint $constraint) {
    /** @var \Drupal\alert_message\AlertMessageInterface $items */
    $publish_date = $items->getPublishDate()->getTimestamp();
    $unpublish_date = $items->getUnPublishDate()->getTimestamp();
    if ($unpublish_date <= \Drupal::time()->getRequestTime()) {
      $this->context->addViolation($constraint->unpublishDateIsPast);
    }
    if ($unpublish_date <= $publish_date) {
      $this->context->addViolation($constraint->unpublishEarlierPublish);
    }
  }

}
