/**
 * @file
 * Alert message read.
 */
((Drupal, Cookie) => {
  Drupal.behaviors.alert_message_read = {
    attach(context) {
      once('alertMessageRead', '.alert-message-close', context).forEach(
        (element) => {
          element.addEventListener(
            'click',
            () => {
              const messageId = element.getAttribute('data-message-id');
              let data = [];
              const cookie = Cookie.get('alertMessageClosed');
              if (typeof cookie === 'string') {
                data = JSON.parse(cookie);
              }
              data.push(messageId);
              Cookie.set('alertMessageClosed', JSON.stringify(data));
              const message = document.getElementById(
                `alert-message-${messageId}`,
              );
              message.remove();
            },
            { once: true },
          );
        },
      );
    },
  };
})(Drupal, window.Cookies);
