<?php

namespace Drupal\alert_telegram\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\NodeType;

/**
 * Configuration form for Alert Telegram settings.
 */
class AlertTelegramSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alert_telegram.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alert_telegram_settings_form';
  }

  /**
   * Builds the settings form.
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('alert_telegram.settings');

    $form['telegram_bot_token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Telegram Bot Token'),
      '#default_value' => $config->get('telegram_bot_token'),
      '#required' => TRUE,
      '#description' => $this->t('Enter your Telegram bot token provided by BotFather.'),
    ];

    $form['webhook_secret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Webhook Secret'),
      '#default_value' => $config->get('webhook_secret'),
      '#required' => TRUE,
      '#description' => $this->t('Enter a secret token to secure the webhook endpoint. This should be a unique and hard-to-guess string.'),
    ];

    // Get all content types.
    $content_types = NodeType::loadMultiple();
    $options = [];
    foreach ($content_types as $machine_name => $content_type) {
      $options[$machine_name] = $content_type->label();
    }

    $form['notify_content_types'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Content types to notify'),
      '#options' => $options,
      '#default_value' => $config->get('notify_content_types') ?: [],
      '#description' => $this->t('Select the content types for which subscribers will be notified when new content is published.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * Form submission handler.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('alert_telegram.settings')
      ->set('telegram_bot_token', $form_state->getValue('telegram_bot_token'))
      ->set('webhook_secret', $form_state->getValue('webhook_secret'))
      ->set('notify_content_types', array_filter($form_state->getValue('notify_content_types')))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
