
# Модуль Alert Telegram

## Опис

Модуль **Alert Telegram** дозволяє інтегрувати ваш сайт Drupal з Telegram-ботом, надаючи такі можливості:

- Користувачі можуть взаємодіяти з сайтом через Telegram-бот, ставити запитання та залишати відгуки.
- Автоматична відправка сповіщень підписникам через Telegram про нові публікації вибраних типів контенту.
- Адміністратори можуть переглядати повідомлення від користувачів через інтерфейс адміністратора.
- Адміністратори отримують сповіщення електронною поштою при отриманні нових запитань або відгуків.

## Вимоги

- Drupal 10
- Обліковий запис Telegram та створений бот

## Встановлення

1. **Встановіть модуль через Composer:**

   ```bash
   composer require drupal/alert_telegram
   ```

2. **Увімкніть модуль:**

   Перейдіть у розділ **Модулі** вашого сайту та увімкніть модуль **Alert Telegram** або скористайтеся командою Drush:

   ```bash
   drush en alert_telegram
   ```

3. **Запустіть оновлення бази даних:**

   ```bash
   drush updb
   ```

## Налаштування

### 1. Створення Telegram-бота

- Відкрийте додаток Telegram і знайдіть користувача **@BotFather**.
- Відправте команду `/newbot` і дотримуйтесь інструкцій для створення нового бота.
- Збережіть отриманий **токен бота** – він знадобиться для налаштування модуля.

### 2. Налаштування модуля

- Перейдіть у розділ налаштувань модуля:

  Адміністрування » Налаштування » Веб-служби » Налаштування Alert Telegram

- Заповніть такі поля:

  - **Telegram Bot Token:** Введіть токен вашого бота, отриманий від BotFather.
  - **Webhook Secret:** Вкажіть унікальний секретний токен для захисту вебхука. Це має бути надійний та унікальний рядок.
  - **Типи контенту для сповіщень:** Виберіть типи контенту, при створенні яких підписники отримуватимуть сповіщення.

- Збережіть налаштування.

### 3. Налаштування вебхука Telegram

- Сформуйте URL вебхука, включаючи ваш секретний токен:

  ```
  https://yourdomain.com/alert-telegram/webhook/your_webhook_secret
  ```

  Замість `yourdomain.com` вкажіть ваш домен, а `your_webhook_secret` замініть на значення, вказане в налаштуваннях модуля.

- Відправте запит для налаштування вебхука:

  ```
  https://api.telegram.org/bot<YOUR_TELEGRAM_BOT_TOKEN>/setWebhook?url=<YOUR_WEBHOOK_URL>
  ```

  Замість `<YOUR_TELEGRAM_BOT_TOKEN>` вкажіть токен вашого бота, а `<YOUR_WEBHOOK_URL>` — URL вебхука.

**Приклад:**

  ```
  https://api.telegram.org/bot123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11/setWebhook?url=https://example.com/alert-telegram/webhook/your_webhook_secret
  ```

- Переконайтеся, що Telegram повернув повідомлення про успішну установку вебхука.

## Додавання команд бота через BotFather

Для покращення взаємодії з користувачами рекомендується додати команди бота через **BotFather**, щоб користувачі могли бачити доступні команди.

### Кроки для додавання команд:

1. **Відкрийте чат з BotFather:**
   - У Telegram знайдіть користувача **@BotFather** і почніть з ним діалог.

2. **Виберіть вашого бота:**
   - Відправте команду `/mybots` і виберіть бота, для якого хочете налаштувати команди.

3. **Налаштування команд:**
   - Відправте команду `/setcommands` і виберіть вашого бота.

4. **Введіть команди:**
   - BotFather попросить вас ввести список команд у такому форматі:
     ```
     команда1 - опис1
     команда2 - опис2
     ```

   - Введіть наступні команди:
     ```
     ask - Задати запитання
     feedback - Залишити відгук
     subscribe - Підписатися на сповіщення про нові публікації
     unsubscribe - Відписатися від сповіщень
     ```

5. **Підтвердження:**
   - BotFather повідомить вам про успішне оновлення команд вашого бота.

### Переваги додавання команд через BotFather:

- **Автодоповнення команд:** Під час введення команд у чаті з ботом користувачі побачать підказки та зможуть вибирати команди зі списку, що полегшує взаємодію.
- **Інтуїтивність:** Користувачі одразу бачать, які команди доступні, і їм не потрібно їх запам'ятовувати.
- **Відповідність стандартам Telegram:** Використання вбудованих команд робить взаємодію зручнішою та відповідає рекомендаціям Telegram.

## Використання

### Для користувачів

- **Початок взаємодії:**

  - Знайдіть вашого бота в Telegram і відправте команду `/start`.
  - Бот відповість вітальним повідомленням із доступними командами.

- **Доступні команди:**

  - `/ask` — Задати запитання.
  - `/feedback` — Залишити відгук.
  - `/subscribe` — Підписатися на сповіщення про нові публікації.
  - `/unsubscribe` — Відписатися від сповіщень.

- **Задати запитання:**

  - Відправте команду `/ask`.
  - Бот попросить вас ввести ваше запитання.
  - Введіть текст запитання.
  - Бот підтвердить отримання запитання.

- **Залишити відгук:**

  - Відправте команду `/feedback`.
  - Бот попросить вас залишити відгук.
  - Введіть текст відгуку.
  - Бот підтвердить отримання відгуку.

### Для адміністратора

- **Перегляд повідомлень від користувачів:**

  - Перейдіть у розділ:

    ```
    Адміністрування » Звіти » Повідомлення Telegram
    ```

  - Тут ви можете переглядати всі запитання та відгуки, надіслані користувачами через Telegram-бот.

- **Отримання сповіщень електронною поштою:**

  - При отриманні нових запитань або відгуків ви будете отримувати сповіщення на електронну пошту, вказану в налаштуваннях сайту (Основні налаштування сайту).

- **Управління підписками:**

  - Користувачі самостійно підписуються та відписуються від сповіщень за допомогою команд `/subscribe` та `/unsubscribe`.

- **Публікація нового контенту:**

  - Під час створення нового матеріалу вибраних типів контенту підписники автоматично отримують сповіщення через Telegram.

## Безпека

- **Секретний токен вебхука:**

  - Переконайтеся, що секретний токен вебхука є надійним та зберігається в таємниці.
  - Це запобігає несанкціонованому доступу до вашого вебхука.

- **SSL-сертифікат:**

  - Telegram вимагає чинний SSL-сертифікат для роботи вебхука.
  - Переконайтеся, що ваш сайт доступний через HTTPS.

