# Модуль Alert Telegram

## Опис

Модуль **Alert Telegram** дозволяє інтегрувати сайт на Drupal з Telegram-ботом і надає наступні можливості:

- Користувачі можуть здійснювати інтеракцію з сайтом через Telegram-бот, задавати питання і лишати відгуки.
- Автоматично надсилати повідомлення підписникам через Telegram про нові публікації обраних типів контенту.
- Адміністратори можуть переглядати повідомлення від користувачів через адмін-інтерфейс.
- Адміністратори отримують повідомлення по email, коли надходять нові питання або відгуки.

## Вимоги

- Drupal 10
- Обліковий запис Telegram і створений бот

## Установлення

1. **Установити модуль через Composer:**

   ```bash
   composer require drupal/alert_telegram
   ```

2. **Включіть модуль:**

   Зайдіть в розділ **Extend** на вашому сайті і включіть модуль **Alert Telegram** або використайте Drush:

   ```bash
   drush en alert_telegram
   ```

3. **Оновіть базу даних:**

   ```bash
   drush updb
   ```

## Конфігурація

### 1. Створення Telegram бота

- Відкрийте застосунок Telegram і знайдіть користувача **@BotFather**.
- Надішліть команду `/newbot` і дотримуйтесь інструкцій для створення нового бота.
- Збережіть **токен бота** – він потрібний для конфігурації модуля.

### 2. Налаштування модуля

- Зайдіть в налаштування модуля:

  Адміністрування » Конфігурація » Веб-сервіси » Alert Telegram Settings

- Заповніть наступні поля:

  - **Telegram Bot Token:** Введіть токен бота, який ви отримали від BotFather.
  - **Webhook Secret:** Вкажіть унікальний секретний токен для захисту webhook. Це має бути сильний і унікальний рядок.
  - **Content types to notify:** Оберіть типи контенту, які тригеруватимуть повідомлення підписникам.
  - **Telegram Bot URL:** Введіть URL вашого Telegram-бота (напр., [https://t.me/YourBotName](https://t.me/YourBotName)).
  - **Notification Emails:** Введіть один або більше адрес по email, кожна з них на новій рядкі, для отримання повідомлень, коли в чаті бота надходить нове повідомлення.

- Збережіть налаштування.

### 3. Налаштування Telegram Webhook

- Згенеруйте URL webhook, додавши ваш секретний токен:

  ```
  https://yourdomain.com/alert-telegram/webhook/your_webhook_secret
  ```

  Замініть `yourdomain.com` на ваш домен і `your_webhook_secret` на значення, вказане в налаштуваннях модуля.

- Надішліть запит на налаштування webhook:

  ```
  https://api.telegram.org/bot<YOUR_TELEGRAM_BOT_TOKEN>/setWebhook?url=<YOUR_WEBHOOK_URL>
  ```

  Замініть `<YOUR_TELEGRAM_BOT_TOKEN>` на токен вашого бота і `<YOUR_WEBHOOK_URL>` на URL webhook.

**Приклад:**

```
https://api.telegram.org/bot123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11/setWebhook?url=https://example.com/alert-telegram/webhook/your_webhook_secret
```

- Переконайтесь, що Telegram повернув повідомлення про успішне налаштування webhook.

## Додавання команд бота через BotFather

Для підвищення якості інтеракції з користувачами рекомендується додати команди бота через **BotFather**, щоб користувачі могли бачити доступні команди.

### Кроки для додавання команд:

1. **Відкрийте чат з BotFather:**

  - У Telegram знайдіть користувача **@BotFather** і почніть розмову.

2. **Оберіть вашого бота:**

  - Надішліть команду `/mybots` і оберіть бота, для якого бажаєте налаштувати команди.

3. **Налаштуйте команди:**

  - Надішліть команду `/setcommands` і оберіть вашого бота.

4. **Введіть команди:**

  - BotFather попросить вас ввести список команд у наступному форматі:

    ```
    command1 - description1
    command2 - description2
    ```

  - Введіть наступні команди:

    ```
    ask - Задати питання
    feedback - Лишити відгук
    subscribe - Підписатися на повідомлення про нові публікації
    unsubscribe - Відписатись від повідомлень
    ```

5. **Підтвердження:**

  - BotFather підтвердить успішне оновлення команд вашого бота.

### Переваги додавання команд через BotFather:

- **Автозаповнення команд:** Під час набору команд у чаті з ботом користувачі будуть бачити підказки і можуть обирати команди з списку, що полегшує їх інтеракцію.
- **Дружній інтерфейс:** Користувачі негайно бачать доступні команди, що зменшує необхідність їх запам’ятовувати.
- **Відповідність стандартам Telegram:** Використання вбудованих команд підвищує якість інтеракції і відповідність рекомендаціям Telegram.

## Використання

### Для користувачів

- **Початок інтеракції:**

  - Знайдіть вашого бота у Telegram і надішліть команду `/start`.
  - Бот відповість повідомленням з привітанням і доступними командами.

- **Доступні команди:**

  - `/ask` — Задати питання.
  - `/feedback` — Лишити відгук.
  - `/subscribe` — Підписатися на повідомлення про нові публікації.
  - `/unsubscribe` — Відписатися від повідомлень.

- **Задавання питання:**

  - Надішліть команду `/ask`.
  - Бот попросить вас ввести питання.
  - Введіть текст вашого питання.
  - Бот підтвердить отримання питання.

- **Лишення відгуку:**

  - Надішліть команду `/feedback`.
  - Бот попросить вас лишити відгук.
  - Введіть текст вашого відгуку.
  - Бот підтвердить отримання відгуку.

### Для адміністратора

- **Перегляд повідомлень від користувачів:**
  - Перейдіть за адресою:

    ```
    Адміністрування » Звіти » Telegram Повідомлення
    ```

  - Тут ви зможете переглядати всі питання і відгуки, надіслані користувачами через Telegram-бот.

- **Отримання повідомлень на email:**
  - Коли надходять нові питання або відгуки, ви отримаєте повідомлення на електронну пошту, вказану в налаштуваннях сайту (Інформація про сайт).

- **Управління підписками:**
  - Користувачі можуть підписуватися і відписуватися від повідомлень через команди `/subscribe` і `/unsubscribe`.

- **Публікація нового контенту:**
  - Коли публікується новий контент обраних типів, підписники автоматично отримують повідомлення через Telegram.

- **Створення блоку з кнопкою 'Telegram Bot':**
  - Перейдіть на сторінку Схема блоків /admin/structure/block
  - Розмістіть блок *Telegram Button* у потрібному регіоні

## Дозволи
- **На сторінці дозволів налаштуйте наступні дозволи**

- Перегляд повідомлень Telegram
- Видалення повідомлень Telegram

## Безпека

- **Секретний токен Webhook:**

  - Переконайтеся, що секретний токен для webhook є захищеним і зберігається конфіденційно.
  - Це запобігає несанкціонованому доступу до вашого webhook.

- **SSL Сертифікат:**

  - Telegram вимагає наявності дійсного SSL-сертифіката для роботи webhook.
  - Переконайтеся, що ваш сайт доступний через HTTPS.

## Додаткова інформація

- **Підтримка:**

  - Якщо у вас виникли питання або проблеми з модулем, будь ласка, звертайтесь до [розробника](mailto:seorusus@gmail.com) або до спільноти Drupal.
  - Допомога в розробці і покращенні модуля вітається.
