
# Alert Telegram Module

## Description

The **Alert Telegram** module allows you to integrate your Drupal site with a Telegram bot, providing the following features:

- Users can interact with the site through a Telegram bot, asking questions and leaving feedback.
- Automatically send notifications to subscribers via Telegram about new publications of selected content types.
- Administrators can view messages from users through the admin interface.
- Administrators receive email notifications when new questions or feedback are received.

## Requirements

- Drupal 10
- Telegram account and created bot

## Installation

1. **Install the module via Composer:**

   ```bash
   composer require drupal/alert_telegram
   ```

2. **Enable the module:**

   Navigate to the **Extend** section of your site and enable the **Alert Telegram** module or use Drush:

   ```bash
   drush en alert_telegram
   ```

3. **Run database updates:**

   ```bash
   drush updb
   ```

## Configuration

### 1. Creating a Telegram Bot

- Open the Telegram app and find the **@BotFather** user.
- Send the `/newbot` command and follow the instructions to create a new bot.
- Save the **bot token** you receive – it will be needed for module configuration.

### 2. Configuring the Module

- Navigate to the module's settings:

  Administration » Configuration » Web services » Alert Telegram Settings

- Fill in the following fields:

  - **Telegram Bot Token:** Enter the bot token you received from BotFather.
  - **Webhook Secret:** Provide a unique secret token to secure the webhook. This should be a strong and unique string.
  - **Content types to notify:** Select the content types that will trigger notifications to subscribers.
  - **Telegram Bot URL:** Enter the URL of your Telegram bot (e.g., https://t.me/YourBotName).
  - **Notification Emails:** Enter one or more email addresses, each on a new line, to receive notifications when a new message is received in the chatbot.

- Save the settings.

### 3. Setting Up the Telegram Webhook

- Generate the webhook URL, including your secret token:

  ```
  https://yourdomain.com/alert-telegram/webhook/your_webhook_secret
  ```

  Replace `yourdomain.com` with your domain and `your_webhook_secret` with the value specified in the module settings.

- Send a request to set up the webhook:

  ```
  https://api.telegram.org/bot<YOUR_TELEGRAM_BOT_TOKEN>/setWebhook?url=<YOUR_WEBHOOK_URL>
  ```

  Replace `<YOUR_TELEGRAM_BOT_TOKEN>` with your bot's token and `<YOUR_WEBHOOK_URL>` with the webhook URL.

**Example:**

  ```
  https://api.telegram.org/bot123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11/setWebhook?url=https://example.com/alert-telegram/webhook/your_webhook_secret
  ```

- Ensure that Telegram returns a success message for the webhook setup.

## Adding Bot Commands via BotFather

For improved user interaction, it is recommended to add bot commands through **BotFather**, so users can see the available commands.

### Steps to Add Commands:

1. **Open chat with BotFather:**
   - In Telegram, find the **@BotFather** user and start a conversation.

2. **Select your bot:**
   - Send the `/mybots` command and choose the bot you want to configure commands for.

3. **Set commands:**
   - Send the `/setcommands` command and choose your bot.

4. **Enter commands:**
   - BotFather will prompt you to enter a list of commands in the following format:
     ```
     command1 - description1
     command2 - description2
     ```

   - Enter the following commands:
     ```
     ask - Ask a question
     feedback - Leave feedback
     subscribe - Subscribe to notifications about new publications
     unsubscribe - Unsubscribe from notifications
     ```

5. **Confirmation:**
   - BotFather will confirm the successful update of your bot's commands.

### Benefits of Adding Commands via BotFather:

- **Command auto-completion:** When typing commands in the chat with the bot, users will see suggestions and can select commands from a list, making interaction easier.
- **User-friendly:** Users immediately see the available commands, reducing the need to remember them.
- **Compliance with Telegram standards:** Using built-in commands enhances interaction and aligns with Telegram’s recommendations.

## Usage

### For Users

- **Starting Interaction:**

  - Find your bot in Telegram and send the `/start` command.
  - The bot will respond with a welcome message and available commands.

- **Available Commands:**

  - `/ask` — Ask a question.
  - `/feedback` — Leave feedback.
  - `/subscribe` — Subscribe to notifications about new publications.
  - `/unsubscribe` — Unsubscribe from notifications.

- **Ask a Question:**

  - Send the `/ask` command.
  - The bot will prompt you to enter your question.
  - Enter your question text.
  - The bot will confirm receipt of your question.

- **Leave Feedback:**

  - Send the `/feedback` command.
  - The bot will prompt you to leave feedback.
  - Enter your feedback text.
  - The bot will confirm receipt of your feedback.

### For Administrator

- **Viewing Messages from Users:**

  - Navigate to:

    ```
    Administration » Reports » Telegram Messages
    ```

  - Here, you can view all the questions and feedback submitted by users through the Telegram bot.

- **Receiving Email Notifications:**

  - When new questions or feedback are received, you will receive notifications via email to the address specified in the site settings (Site Information).

- **Managing Subscriptions:**

  - Users can subscribe and unsubscribe from notifications via the `/subscribe` and `/unsubscribe` commands.

- **Publishing New Content:**

  - When new content of selected types is published, subscribers automatically receive notifications via Telegram.

- **Create a block with the 'Telegram Bot' button**

- Go to the Block Scheme page /admin/structure/block
- Place the *Telegram Button* block in the required region

## Permissions
- **On the permissions page, configure the following permissions**

- View Telegram messages
- Delete Telegram messages

## Security

- **Webhook Secret Token:**

  - Ensure the webhook secret token is secure and kept confidential.
  - This prevents unauthorized access to your webhook.

- **SSL Certificate:**

  - Telegram requires a valid SSL certificate for the webhook to work.
  - Make sure your site is accessible via HTTPS.

## Additional information

    - **Support:**
  
      - If you have any questions or problems with the module, please contact [the developer](mailto:seorusus@gmail.com) or the Drupal community.
      - Help in developing and improving the module is welcome.