<?php

namespace Drupal\alert_telegram\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;

/**
 * Checks access for viewing Telegram messages based on permission.
 */
class TelegramMessageAccessCheck implements ContainerInjectionInterface {

  /**
   * Constructs a TelegramMessageAccessCheck object.
   */
  public function __construct() {
    // No dependencies needed, so the constructor is empty.
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static();
  }

  /**
   * Checks access for viewing Telegram messages.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The current user account.
   *
   * @return \Drupal\Core\Access\AccessResult
   *   The access result.
   */
  public function access(AccountInterface $account) {
    // Allow access only if the user has the 'view telegram messages' permission.
    return $account->hasPermission('view telegram messages')
      ? AccessResult::allowed()
      : AccessResult::forbidden();
  }

}
