/**
 * @file
 **/

(function ($, window, Drupal, drupalSettings, cookies) {

  Drupal.Alerts = {};

  Drupal.behaviors.AlertsService = {
    attach: function attach(context) {
      $(context).find('[data-alert-types]').once('data-alert-types').each(function () {
        var _this = this;
        var path = "/" + drupalSettings.path.currentPath;
        var params = {
          '_format': 'json',
          'path': path,
        };

        var query = $.param(params, true);
        var url = window.location.protocol + "//" + window.location.host + '/alerts/json?' + query;

        $.ajax({
          url: url,
          method: "GET",
          headers: {
            'Content-Type': "application/vnd.api+json",
            'Accept': 'application/vnd.api+json"',
          },
          success: function (response, status, xhr) {
            response.data.some(function (item) {
              if (drupalSettings.alerts.includes(item.id)) {
                var cookieName = 'alert--' + item.id;
                // Check to see if user has no cookie set for this alert or if
                // they have not yet dismissed it.
                var show = (!cookies.get(cookieName) || cookies.get(cookieName) === 'shown');

                // Add alert if it has rendered content and has not been dismissed.
                if (item.content && show) {
                  $(_this).append(item.content);
                  return true;
                }
              }
            });
          },
          complete: function (xhr, status) {
            $(_this).find('.alert').once('setupAlerts').each(function (i, e) {
              let a = new Drupal.Alerts.Alert(e);
            });
          }
        });
      });
    }
  };

  Drupal.Alerts.Alert = function ($target) {
    this.$el = $($target)
    this.$closeButton = this.$el.find('.alert--close')
    this.dismissTimer = this.$el.data('dismiss-timer')
    this.cookieName = this.$el.attr('id')
    this.speed = 500
    var self = this;

    this.close = function () {
      self.$el.slideUp(this.speed, function (e) {
        cookies.set(self.cookieName, 'dismissed')
      });
    }

    this.open = function () {
      self.$el.slideDown(this.speed, function (e) {
        cookies.set(self.cookieName, 'shown')
      });
    }

    this.$closeButton.on('click', function (e) {
      e.preventDefault();
      self.close()
    });

    if (!cookies.get(this.cookieName) || cookies.get(this.cookieName) === 'shown') {
      self.open()
    }

    if (this.dismissTimer > 0) {
      setTimeout(function () {
        self.close()
      }, (this.dismissTimer * 1000))
    }
  }

})(jQuery, window, Drupal, drupalSettings, window.Cookies);
