<?php

namespace Drupal\alert_types\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Datetime\DateFormatter;
use Symfony\Component\HttpFoundation\JsonResponse;
use Drupal\Core\Render\Renderer;

/**
 * Class AlertServiceController.
 *
 * @package Drupal\alert_types\Controller
 */
class AlertServiceController extends ControllerBase implements ContainerInjectionInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The date formatter service.
   *
   * @var \Drupal\Core\Datetime\DateFormatter
   */
  protected $dateFormatter;

  /**
   * The renderer service.
   *
   * @var \Drupal\Core\Render\Renderer
   */
  protected $renderer;

  /**
   * AlertServiceController constructor.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\Core\Datetime\DateFormatter $date_formatter
   *   The date formatter service.
   * @param \Drupal\Core\Render\Renderer $renderer
   *   The renderer service.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, DateFormatter $date_formatter, Renderer $renderer) {
    $this->entityTypeManager = $entity_type_manager;
    $this->dateFormatter = $date_formatter;
    $this->renderer = $renderer;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager'),
      $container->get('date.formatter'),
      $container->get('renderer')
    );
  }

  /**
   * Fetches all the release data and returns them
   * with appropriate context data.
   */
  public function json() {
    /** @var \Drupal\Core\Render\Renderer $renderer */
    $viewBuilder = $this->entityTypeManager->getViewBuilder('alert');
    $entity_ids = \Drupal::entityQuery('alert')
      ->condition('status', 1)
      ->sort('weight', 'ASC')
      ->execute();
    $entities = $this->entityTypeManager->getStorage('alert')->loadMultiple($entity_ids);
    $items = [];
    // We need to render the full HTML markup before sending it to the JSON response.
    foreach ($entities as $entity) {
      $render_array = $viewBuilder->view($entity);
      $render = $this->renderer->render($render_array);
      $items[] = [
        'id' => $entity->id(),
        'content' => $render
      ];
    }

    return new JsonResponse([
      'data' => $items,
      'status' => 200,
      'method' => 'GET',
    ]);
  }

}
