# Alerts

This recipe creates a system for storing and displaying alerts on your website.
Visitors can click a banner to view the details, or they can dismiss a banner,
and dismissed banners have their ids stored in the browser's localStorage, so
the same banner won't be shown on other pages or subsequent visits.

In addition to creating a content type for alerts, this also provides a
view for displaying them, sorted chronologically by creation with the most
recent first. It also creates a new taxonomy vocabulary, which can be used to
define the severity options available to content creators.

An optional module is available to allow better formatting, and the JavaScript
to store which banners have been dismissed. That module optimizes for the
Olvero theme, but may be compatible with other themes too.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/alerts).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/alerts).


## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers


## Requirements

This recipe requires the Add Content by Bundle module to simplify the process of
adding alerts. Also, the Color Field module is used to provide an intuitive
widget for selecting colors for the alerts based on their severity.


## Installation

- Install the Alerts recipe as you would normally install a contributed Drupal
  recipe. See the Recipes [Getting Started Guide](https://git.drupalcode.org/project/distributions_recipes/-/blob/1.0.x/docs/getting_started.md) for further information. We strongly recommend using
  composer to ensure all dependencies will be handled automatically.
- This will import configuration. The Alert Severity vocabulary includes a color
  field, to allow site builders to choose colors that will act as a visual guide
  to site visitors. Passing the chosen colors into the page markup requires a
  module, so you can either install the [Alerts Format module](https://www.drupal.org/project/alerts_format) or add equivalent
  code to your site's custom theme. If you don't  require this (for example if
  hard-coding the background colors into your theme instead) you can skip adding
  any code, and delete the color field from the Alert Severity vocabulry.


## Configuration

1. When installed, the provided Alerts view will have two displays: one for a
   standard list display, and the other a block showing up to 5 most recently
   posted alerts.
2. You may want to customize what information is captured and displayed for the
   Alert nodes on your site. If so, add fields according to the [Field UI documentation](https://www.drupal.org/docs/7/nodes-content-types-and-fields/add-a-field-to-a-content-type).
3. You may also want to add to the Alert Severity vocabulary, for example to add
   a SVG Image Field that would allow for a specific icon to appear on alert
   banners. Note that if implementing this you will need to add a mechanism to
   get the icon to display. One approach would be to update the Alerts view
   with a relationship to the taxonomy term, and then place the icon field into
   the display. Alternatively (and especially if using a custom theme) you could
   customize the code that dynamically generates CSS (provided inside
   alerts.module) to include whatever fields and formatting you need, inside
   your theme.


## Maintainers

- Martin Anderson-Clutz - [mandclu](https://www.drupal.org/u/mandclu)
