<?php

/**
 * Display plugin for Alexa Flash Briefings.
 */
class views_plugin_alexa_flash_briefing_display extends views_plugin_display_feed {
  function get_style_type() {
    return 'alexa_flash_briefing';
  }

  function option_definition() {
    $options = parent::option_definition();

    $options['style_plugin']['default'] = 'alexa_flash_briefing_text_json';

    return $options;
  }

  function options_summary(&$categories, &$options) {
    // It is very important to call the parent function here:
    parent::options_summary($categories, $options);

    unset($options['displays']);
    unset($options['exposed_block']);
    unset($options['exposed form']);
    unset($options['css_class']);
  }

  /**
   * Provide the default form for setting options.
   */
  function options_form(&$form, &$form_state) {
    // It is very important to call the parent function here.
    parent::options_form($form, $form_state);

    switch ($form_state['section']) {
      case 'path':
        t('This view will be displayed by visiting this path on your site. It is recommended that the path be something like "alexa/%/%/flash-briefing.json" or "alexa/news/%/%/briefing.json", putting one % in the path for each contextual filter you have defined in the view.');
        break;
    }
  }

  function uses_link_display() {
    return FALSE;
  }
}
