<?php

class views_plugin_alexa_flash_briefing_style_text_json extends views_plugin_style {
  function option_definition() {
    $options = parent::option_definition();

    $options['fields'] = array('contains' => array());
    foreach (array_keys($this->_get_fields()) as $key) {
      $options['fields']['contains'][$key] = array('default' => '');
    }

    return $options;
  }

  function options_form(&$form, &$form_state) {
    parent::options_form($form, $form_state);

    // Ensure fields have been added to the view.
    $field_handlers = $this->display->handler->get_handlers('field');
    if (empty($field_handlers)) {
      return;
    }

    // Build an array of fields to use as form options.
    $field_options = array();
    foreach ($field_handlers as $field => $handler) {
      $field_options[$field] = $handler->label() ?: $handler->ui_name();
    }

    $form['fields'] = array(
      '#type' => 'fieldset',
      '#title' => t('Fields'),
      '#description' => t('Select the fields to use in the Flash Briefing feed'),
    );

    foreach ($this->_get_fields() as $field => $definition) {
      $form['fields'][$field] = array(
        '#type' => 'select',
        '#title' => $definition['title'],
        '#description' => $definition['description'],
        '#options' => $field_options,
        '#default_value' => $this->options['fields'][$field],
      );
    }
  }

  function options_validate(&$form, &$form_state) {
    parent::options_validate($form, $form_state);

    $date_field = $form_state['input']['style_options']['fields']['date'];
    $field = $this->display->handler->get_handler('field', $date_field);
    if (!$field instanceof views_handler_field_date) {
      form_error($form['fields']['date'], t('A date field must be used for the feed\'s Date (currently set to "%group: %title")', array('%group' => $field->definition['group'], '%title' => $field->definition['title'])));
    }
  }

  function validate() {
    $errors = parent::validate();

    foreach ($this->options['fields'] as $value) {
      if (empty($value)) {
        $errors[] = t('One or more fields have not been configured in the JSON format settings.');
        break;
      }
    }

    $handler = $this->display->handler;
    if ($handler->options['pager']['type'] === 'some') {
      $per_page = $handler->options['pager']['options']['items_per_page'];
      if ($per_page == 0 || $per_page > 5) {
        $errors[] = t('"Items to display" is too high; Alexa only supports up to 5 items');
      }
    }
    else {
      $errors[] = t('Limit the "Items to display" to no more than 5 items');
    }

    foreach ($handler->get_handlers('field') as $field => $field_handler) {
      if ($field === $this->options['fields']['link'] && $field_handler instanceof views_handler_field_node_path) {
        if (!$field_handler->options['absolute']) {
          $errors[] = t('"%group: %title" must be an absolute URL', array('%group' => $field_handler->definition['group'], '%title' => $field_handler->definition['title']));
        }
      }
    }

    return $errors;
  }

  function render() {
    // Make sure fields are rendered.
    $this->render_fields($this->view->result);

    $date = new DateTime('now', new DateTimeZone('UTC'));

    $data = array();
    foreach ($this->rendered_fields as $i => $row) {
      // Convert UNIX timestamp.
      $d = $this->get_field_value($i, $this->options['fields']['date']);
      $d = $date->setTimestamp($d)->format('Y-m-d\TH:i:s.0\Z');

      $data[] = array(
        'uid' => $row[$this->options['fields']['uid']],
        'updateDate' => $d,
        'titleText' => $row[$this->options['fields']['title']],
        'mainText' => $row[$this->options['fields']['description']],
        'redirectionURL' => $row[$this->options['fields']['link']],
      );
    }

    if (count($data) === 1) {
      $data = $data[0];
    }

    if (empty($this->view->live_preview)) {
      drupal_add_http_header('Content-Type', 'application/json; utf-8');
    }

    if (!defined('JSON_PRETTY_PRINT')) {
      return json_encode($data);
    }

    return json_encode($data, JSON_PRETTY_PRINT);
  }


  function _get_fields() {
    return array(
      'uid' => array(
        'title' => t('Identifier'),
        'description' => t('Unique identifier for each feed item (UUID format preferred, but a nid is okay too)'),
      ),
      'date' => array(
        'title' => t('Date'),
        'description' => t('Used to order items to be read from newest to oldest. Will be formatted automatically.'),
      ),
      'title' => array(
        'title' => t('Title'),
        'description' => t('The title of the feed item to display in the Alexa app (no HTML allowed)'),
      ),
      'description' => array(
        'title' => t('Text content'),
        'description' => t('The text that is read to the user (4500 characters max; no HTML allowed)'),
      ),
      'link' => array(
        'title' => t('Display URL'),
        'description' => t('Provides the URL target for the Read More link in the Alexa app (absolute URL to path alias; no HTML allowed)'),
      ),
    );
  }

}
