<?php
// $Id: alfresco_handler_field_url_download.inc,v 1.2.2.1 2009/01/29 17:10:31 xergius Exp $

/**
 * Field handler to provide simple renderer that turns a URL into a clickable link.
 *
 * @ingroup views_field_handlers
 */
class alfresco_handler_field_url_download extends views_handler_field {
  function construct() {
    parent::construct();
    $this->additional_fields['nid'] = array('table' => 'node', 'field' => 'nid');
    $this->additional_fields['uid'] = array('table' => 'node', 'field' => 'uid');
    $this->additional_fields['type'] = array('table' => 'node', 'field' => 'type');
    $this->additional_fields['title'] = array('table' => 'node', 'field' => 'title');
    $this->additional_fields['size'] = array('table' => 'alfresco_content', 'field' => 'size');
    $this->additional_fields['cm_name'] = 'cm_name';
  }

  function option_definition() {
    $options = parent::option_definition();

    $options['use_title'] = array('default' => FALSE);
    $options['display_as_link'] = array('default' => TRUE);

    return $options;
  }

  /**
   * Provide link to the page being visited.
   */
  function options_form(&$form, &$form_state) {
    parent::options_form($form, $form_state);
    $form['use_title'] = array(
      '#title' => t('Use title node as filename'),
      '#type' => 'checkbox',
      '#default_value' => !empty($this->options['use_title']),
    );

    $form['display_as_link'] = array(
      '#title' => t('Display as download link'),
      '#type' => 'checkbox',
      '#default_value' => !empty($this->options['display_as_link']),
    );
  }

  function render($values) {
    if (!empty($this->options['use_title'])) {
      $value = $values->{$this->aliases['title']};
    }
    else {
      $value = $values->{$this->field_alias};
    }
    $is_file = $values->{$this->aliases['size']} > 0;
    if (!empty($this->options['display_as_link']) && user_access('download alfresco content') && $is_file) {
      $node = new stdClass();
      $node->nid = $values->{$this->aliases['nid']};
      $node->uid = $values->{$this->aliases['uid']};
      $node->type = $values->{$this->aliases['type']};
      $node->title = $values->{$this->aliases['title']};
      $node->cm_name = $values->{$this->aliases['cm_name']};
      $node->cm_content = TRUE;

      $url = alfresco_url_download($node);

      return l(check_plain($value), $url, array('html' => TRUE));
    }
    else {
      return $value;
    }
  }
}