<?php

namespace Drupal\all_in_one_accessibility\Form;

use Drupal\Core\Form\ConfigFormBase;
use Symfony\Component\HttpFoundation\Request;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provide settings page for adding CSS/JS before the end of body tag.
 */
class UseridForm extends ConfigFormBase {

  /**
   * Implements FormBuilder::getFormId.
   */
  public function getFormId() {
    return 'all_in_one_accessibility';
  }

  /**
   * Implements ConfigFormBase::getEditableConfigNames.
   */
  protected function getEditableConfigNames() {
    return ['all_in_one_accessibility.userid.settings'];
  }

  /**
   * Implements FormBuilder::buildForm.
   */
  public function buildForm(array $form, FormStateInterface $form_state, Request $request = NULL) {
    $allinone_userid = $this->config('all_in_one_accessibility.userid.settings')->get();


    $form['allinone']['userid'] = [
      '#type'          => 'textfield',
      '#title'         => $this->t('License Key'),
      '#default_value' => isset($allinone_userid['userid']) ? $allinone_userid['userid'] : '',
      '#description'   => empty($allinone_userid['userid']) ? $this->t('<p>You are currently using Free version which have limited features. </br>Please <a href="https://www.skynettechnologies.com/add-ons/product/all-in-one-accessibility/">Sign up</a> and get License Key for additional features on the ADA Widget.</p>') : '',
      '#rows'          => 10,
    ];

    $form['allinone']['colorcode'] = [
      '#type'          => 'textfield',
      '#title'         => $this->t('Hex color code'),
      '#default_value' => isset($allinone_userid['colorcode']) ? $allinone_userid['colorcode'] : '',
      '#description'   => $this->t('<p>You can cutomize the ADA Widget color. For example: #FF5733'),
      '#rows'          => 10,
    ];


    $options = array(
      'top_left' => $this->t('Top left'),
      'top_center' => $this->t('Top Center'),
      'top_right' => $this->t('Top Right'),
      'middel_left' => $this->t('Middle left'),
      'middel_right' => $this->t('Middle Right'),
      'bottom_left' => $this->t('Bottom left'),
      'bottom_center' => $this->t('Bottom Center'),
      'bottom_right' => $this->t('Bottom Right')
    );

    $form['allinone']['position'] = [
      '#type' => 'radios',
      '#title' => $this->t('Where would you like to place the accessibility icon on your site?'),
      '#options' => $options,
      '#default_value' => isset($allinone_userid['position']) ? $allinone_userid['position'] : 'bottom_right',
    ];


    return parent::buildForm($form, $form_state);
  }

  /**
   * Implements FormBuilder::submitForm().
   *
   * Serialize the user's settings and save it to the Drupal's config Table.
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();

    $this->configFactory()
      ->getEditable('all_in_one_accessibility.userid.settings')
      ->set('userid', $values['userid'])
      ->save();

    $this->configFactory()
    ->getEditable('all_in_one_accessibility.userid.settings')
    ->set('colorcode', $values['colorcode'])
    ->save();

    $this->configFactory()
    ->getEditable('all_in_one_accessibility.userid.settings')
    ->set('position', $values['position'])
    ->save();


    $this->messenger()->addStatus($this->t('Your Settings have been saved.'));
      drupal_flush_all_caches();
  }

}
