<?php

/**
 * @file
 * Contains alpha_numeric_glossary\alpha_numeric_glossary.views.inc.
 *
 * Provide a custom views field data that isn't tied to any other module.
 */

/**
 * Implements hook_views_data().
 */
function alpha_numeric_glossary_views_data() {

  $data['views']['table']['group'] = t('Custom Global');
  $data['views']['table']['join'] = [
    // #global is a special flag which allows a table to appear all the time.
    '#global' => [],
  ];

  $data['views']['alpha_numeric_glossary'] = [
    'title' => t('Alpha Numeric Glossary'),
    'help' => t('Adds alpha numeric glossary.'),
    'area' => [
      'id' => 'alpha_numeric_glossary',
    ],
  ];

  $data['views']['alpha_numeric_glossary_group'] = [
    'title' => t('Alpha Numeric Glossary'),
    'help' => t('Adds an automated field that can be used to group by the alpha numeric glossary prefix.'),
    'field' => [
      'id' => 'alpha_numeric_glossary_group',
    ],
  ];

  return $data;
}
