<?php

namespace Drupal\alr\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form definition for the salutation message.
 */
class ALRConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alr.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alr_configuration_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('alr.settings');
    $form['enable_alf_fields'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable the after Log in'),
      '#default_value' => $config->get('enable_alf_fields'),
    ];
    $form['redirection_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Redirection URL for after Log in'),
      '#description' => $this->t('Enter Redirection URL for the Log in'),
      '#maxlength' => 255,
      '#size' => 100,
      '#default_value' => $config->get('redirection_url'),
      '#states' => [
        'visible' => [
          ':input[name="enable_alf_fields"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['enable_logout_fields'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable the after Log out'),
      '#default_value' => $config->get('enable_logout_fields'),
    ];
    $form['redirection_logout_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Redirection URL for after Log out'),
      '#description' => $this->t('Enter Redirection URL for the Log out'),
      '#maxlength' => 255,
      '#size' => 100,
      '#default_value' => $config->get('redirection_logout_url'),
      '#states' => [
        'visible' => [
          ':input[name="enable_logout_fields"]' => ['checked' => TRUE],
        ],
      ],
    ];

    $form['actions'] = [
      '#type' => 'actions',
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Save configuration'),
      '#submit' => ['::submitForm'],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $this->config('alr.settings')
      ->set('enable_alf_fields', $form_state->getValue('enable_alf_fields'))
      ->set('redirection_url', $form_state->getValue('redirection_url'))
      ->set('enable_logout_fields', $form_state->getValue('enable_logout_fields'))
      ->set('redirection_logout_url', $form_state->getValue('redirection_logout_url'))
      ->save();
  }

}
