<?php

namespace Drupal\alt_text_import_csv\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\multivalue_form_element\Element\MultiValue;

/**
 * Settings form for alt text import CSV module.
 */
class AdminSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alt_text_import_csv.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alt_text_import_csv_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);

    $config = $this->config('alt_text_import_csv.settings');

    $form['mails'] = [
      '#type' => 'multivalue',
      '#title' => $this->t('Notification recipients'),
      '#cardinality' => MultiValue::CARDINALITY_UNLIMITED,
      'mail' => [
        '#type' => 'email',
        '#title' => $this->t("Email"),
      ],
      '#description' => $this->t("The email addresses to send CSV upload reports to. To disable sending of reports, remove all email addresses."),
      '#default_value' => $config->get('mails') ?? [],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);

    $config = $this->config('alt_text_import_csv.settings');

    $mails = array_column($form_state->getValue('mails'), 'mail');

    $config->set('mails', $mails);
    $config->save();
  }

}
