<?php

namespace Drupal\alt_text_validation\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Alt Text Validation Setting form.
 */
class AltTextValidationSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alt_text_validation_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alt_text_validation.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form['#title'] = $this->t('Alt Text Validation Settings');
    $form['alt_text_validation_setting'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Alt Text Validation Setting Forms'),
      '#description' => $this->t('Select this checkbox if you want to enable the functionality of alt text validation.'),
      '#default_value' => $this->config('alt_text_validation.settings')->get('alt_text_validation_setting'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory()->getEditable('alt_text_validation.settings');
    $config->set('alt_text_validation_setting', $form_state->getValue('alt_text_validation_setting'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
