<?php

/**
 * @file
 * Alt text validation views data and tables.
 */

/**
 * Implements hook_views_data().
 */
function alt_text_validation_views_data() {
  $data = [];
  // Alt text audit data.
  $data['alt_text_validation_audit'] = [];
  $audit_table = [
    'group' => t('ATV'),
    'title' => t('Alt text audit'),
    'provider' => 'alt_text_validation',
  ];
  $audit_table['base'] = [
    'field' => 'file_source',
    'title' => t('Alt text audit'),
    'help' => t('Access to the alt text audit table built by periodic scan.'),
  ];
  $data['alt_text_validation_audit']['table'] = $audit_table;
  // Define the database & View fields.
  $data['alt_text_validation_audit']['filename'] = [
    'title' => t('Filename'),
    'help' => t('Image filename with extension.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['alt_text'] = [
    'title' => t('Alt text'),
    'help' => t('Alt attribute for image.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['warnings'] = [
    'title' => t('Warning count'),
    'help' => t('The number of warnings for the alt text.'),
    'field' => [
      'id' => 'numeric',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'numeric',
    ],
  ];
  $data['alt_text_validation_audit']['violations'] = [
    'title' => t('Violation count'),
    'help' => t('The number of violations for the alt text.'),
    'field' => [
      'id' => 'numeric',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'numeric',
    ],
  ];
  $data['alt_text_validation_audit']['title'] = [
    'title' => t('Image title'),
    'help' => t('Title attribute for image.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['entity'] = [
    'title' => t('Host entity'),
    'help' => t('The entity type the image is a part of'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['bundle'] = [
    'title' => t('Host bundle'),
    'help' => t('The bundle the image is a part of.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['id'] = [
    'title' => t('Host entity id'),
    'help' => t('The entity id the image is a part of.'),
    'field' => [
      'id' => 'numeric',
    ],
    'filter' => [
      'id' => 'numeric',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'numeric',
    ],
  ];
  $data['alt_text_validation_audit']['field_name'] = [
    'title' => t('Field name'),
    'help' => t('The machine name of the field hosting the image.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];
  $data['alt_text_validation_audit']['file_source'] = [
    'title' => t('File source'),
    'help' => t('The full location of the image file.'),
    'field' => [
      'id' => 'standard',
    ],
    'filter' => [
      'id' => 'string',
    ],
    'sort' => [
      'id' => 'standard',
    ],
    'argument' => [
      'id' => 'string',
    ],
  ];

  return $data;
}
