<?php

namespace Drupal\alt_text_validation\Drush\Commands;

use Drupal\alt_text_validation\Service\AuditStorageInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\State\State;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Utility\Token;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Drush\Drush;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A Drush command file.
 */
final class AltTextValidationCommands extends DrushCommands implements ContainerInjectionInterface {

  use StringTranslationTrait;

  /**
   * The audit storage service.
   *
   * @var \Drupal\alt_text_validation\Service\AuditStorageInterface
   */
  protected $auditStorage;

  /**
   * The configuration for alt_text_validation.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The state api service.
   *
   * @var \Drupal\Core\State\State
   */
  public $state;

  /**
   * Constructs a AltTextValidationCommands object.
   */
  public function __construct(
    AuditStorageInterface $alt_text_storage,
    ConfigFactoryInterface $config_factory,
    State $state,
    private readonly Token $token,
  ) {
    parent::__construct();
    $this->auditStorage = $alt_text_storage;
    $this->configFactory = $config_factory;
    $this->config = $this->configFactory->getEditable('alt_text_validation.settings');
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('alt_text_validation.audit_service'),
      $container->get('config.factory'),
      $container->get('state'),
      $container->get('token')
    );
  }

  /**
   * Insert test Audit logs into the table.
   *
   * @param array $options
   *   The array of option flags passed in.
   *
   * @todo This command will go away once this is moved to a unit test.
   */
  #[CLI\Command(name: 'alt-text-validation:fillAuditTest', aliases: ['atvfat'])]
  #[CLI\Usage(name: 'drush alt-text-validation:fillAuditTest', description: 'Populate the audit table with test data.')]
  public function fillAuditTest($options = ['reset' => FALSE]) {
    $this->auditStorage->generateTestData();
    $vars = [
      '@table' => 'alt_text_validation_audit',
    ];

    Drush::output()->writeln($this->t('The @table has been emptied and filled with test rows.', $vars));
  }

}
