<?php

namespace Drupal\alt_text_validation\Service;

/**
 * Class generate the audit.
 */
interface AuditorInterface {

  /**
   * Adds all images to the queue via two-step queueing.
   */
  public function queueAllImages(): void;

  /**
   * Checks to see if the field type is an alt containing field type.
   *
   * @param string $field_type
   *   The field type to check.
   *
   * @return bool
   *   TRUE if the field type is an image type field, FALSE otherwise.
   */
  public function isImageTypeField(string $field_type): bool;

  /**
   * Gets the type of fields that can have alt text.
   *
   * @return array
   *   An array of field types that can have alt text.
   */
  public function getImageFieldTypes(): array;

}
