<?php

namespace Drupal\alt_text_validation\Service;

use Drupal\Core\Entity\EntityInterface;

/**
 * Class perform validations.
 */
interface ValidatorInterface {

  /**
   * Process all validation rules and return the violations.
   *
   * @param string $filename
   *   The file name of the image file.
   * @param string $alt
   *   The alt text of the image.
   * @param string $title
   *   The title text of the image.
   *
   * @return array
   *   An array of any violations triggered.
   */
  public function getViolations(string $filename, string $alt, string $title): array;

  /**
   * Process all validation rules and return the warnings.
   *
   * @param string $filename
   *   The file name of the image file.
   * @param string $alt
   *   The alt text of the image.
   * @param string $title
   *   The title text of the image.
   *
   * @return array
   *   An array of any warnings triggered.
   */
  public function getWarnings(string $filename, string $alt, string $title): array;

  /**
   * Checks if a field is considered an image field.
   *
   * @param string $field_name
   *   The field name.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   *
   * @return bool
   *   TRUE if the field is an image field, FALSE otherwise.
   */
  public function isImageField(string $field_name, EntityInterface $entity):  bool;

  /**
   * Validate the data in an image field instance.
   *
   * @param string $field_name
   *   The field name.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   *
   * @return array
   *   An array of validation information.
   */
  public function validateImageField(string $field_name, EntityInterface $entity): array;

  /**
   * Validate the image data in a text field instance.
   *
   * @param string $field_name
   *   The field name.
   * @param Drupal\Core\Entity\EntityInterface $entity
   *   The entity.
   *
   * @return array
   *   An array of validation information.
   */
  public function validateTextField(string $field_name, EntityInterface $entity): array;

}
