<?php

namespace Drupal\alt_text_validation\Drush\Commands;

use Drupal\alt_text_validation\AtvCommonTrait;
use Drupal\alt_text_validation\Service\Auditor;
use Drupal\alt_text_validation\Service\AuditStorageInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\State\State;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Utility\Token;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Drush\Drush;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * A Drush command file.
 */
final class AltTextValidationCommands extends DrushCommands implements ContainerInjectionInterface {
  use AtvCommonTrait;
  use StringTranslationTrait;

  /**
   * The auditor service.
   *
   * @var \Drupal\alt_text_validation\Service\Auditor
   */
  protected $auditor;

  /**
   * The audit storage service.
   *
   * @var \Drupal\alt_text_validation\Service\AuditStorageInterface
   */
  protected $auditStorage;

  /**
   * The configuration for alt_text_validation.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The state api service.
   *
   * @var \Drupal\Core\State\State
   */
  public $state;

  /**
   * Constructs a AltTextValidationCommands object.
   */
  public function __construct(
    Auditor $auditor,
    AuditStorageInterface $alt_text_storage,
    ConfigFactoryInterface $config_factory,
    State $state,
    private readonly Token $token,
  ) {
    parent::__construct();
    $this->auditor = $auditor;
    $this->auditStorage = $alt_text_storage;
    $this->configFactory = $config_factory;
    $this->config = $this->configFactory->getEditable('alt_text_validation.settings');
    $this->state = $state;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('alt_text_validation.auditor'),
      $container->get('alt_text_validation.audit_service'),
      $container->get('config.factory'),
      $container->get('state'),
      $container->get('token')
    );
  }

  /**
   * Insert test Audit logs into the table.
   *
   * @param array $options
   *   The array of option flags passed in.
   *
   * @todo This command will go away once this is moved to a unit test.
   */
  #[CLI\Command(name: 'alt-text-validation:fill-audit-test', aliases: ['atv-fat'])]
  #[CLI\Usage(name: 'drush alt-text-validation:fillAuditTest', description: 'Populate the audit table with test data.')]
  public function fillAuditTest($options = ['reset' => FALSE]) {
    $this->auditStorage->generateTestData();
    $vars = [
      '@table' => self::getAuditTableName(),
    ];

    Drush::output()->writeln($this->t('The @table has been emptied and filled with test rows.', $vars));
  }

  /**
   * Queue all images for auditing.
   *
   * @param array $options
   *   The array of option flags passed in.
   */
  #[CLI\Command(name: 'alt-text-validation:queue-audit', aliases: ['atv-queue'])]
  #[CLI\Usage(name: 'drush alt-text-validation:queue-audit', description: 'Populate the audit table with test data.')]
  public function queueAudit($options = ['reset' => FALSE]) {
    $this->auditor->queueAllImages();
    $vars = [
      '@table' => self::getAuditTableName(),
    ];

    Drush::output()->writeln($this->t('All images have been queued for auditing.', $vars));
  }

}
