**This module is not functional yet.** It is only here for contributors to work on it.

## Introduction

This module is being developed to help prevent editors from writing bad alt text
on images. This module will do a few things:

- Provide a report of all alt text attached to images for auditing purposes.
- Provide customizable rules to validate alt text against during save.
- Both server side and client side validation of the rules against submitted alt
  text.



## Table of contents

- Requirements
- Installation
- Configuration
- Report

## Requirements

This module requires
  * drupal:field (part of Drupal core)
  * drupal:[views_data_export](https://www.drupal.org/project/views_data_export)


## Installation

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.


## Configuration

Configuration steps are minimal:

  1. Go to /admin/config/content/alt-text-validation and configure.
  2. Assign permissions for administering the module and viewing the report to Roles.


## Report

The Alt Text Audit report is present at Reports >> Alt Text Report (/admin/reports/alt-text-report) for properly permed users.  This report is a View that can be modified if needed.  It requires the Auditor job be run to populate the report. The audit report will
show any occurrences of image fields on any entity.  It also includes any html image tags found within text fields on any entity.  Scroll to the bottom of the report to see the CSV icon to download a CSV of the current View.

There are currently two ways to initialize the report generation.  Depending on the
size of your site, it may be an intensive process.
To populate the report you will need to either:

1. Enable report generation in cron (/admin/reports/alt-text-report) - It will begin the generation with the next cron run.
2. Via Drush command.
```
drush alt-text-validation:queue-audit
drush cron
```
It uses the Queue API and may take several cron runs to fully populate the report. You can assess the progress by `drush queue:list` then look for `atv_entity_instances`
The top of the report contains information about when the report was started and finished.

## Drush Commands

  - drush alt-text-validation:queue-audit - this command queues up the entities to audit.  It requires cron to run (perhaps more than once) to complete the audit.
  - drush alt-text-validation:fill-audit-test - this command populates the audit table with test data.  This command is for development and testing only. It will be removed once the module has a stable release.

## Developers and Contributors

This project uses [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib)
   - Install ddev locally.
   - Clone the alt_text_validation project repository or any issue fork
   - Refer to the [ddev-drupal-contrib readme](https://github.com/ddev/ddev-drupal-contrib)  file for instructions on using the plugin and the testing tools it provides (phpunit, phpcs, eslint, etc).
