CONTRIBUTING
------------

You may setup your local environment with [Ddev]. This project leverages the
[Ddev Drupal Contrib] plugin.

You should only need to run these steps one time.

1.  [Install Ddev] with a [Docker provider].
2.  Clone this project's repository from Drupal's GitLab.

        git clone git@git.drupal.org:project/alt_text_validation.git
        cd alt_text_validation

3.  Run these ddev initial setup commands to configure a Drupal 10 project and install the Ddev Drupal Contrib plugin.

        ddev config --project-type=drupal10 --docroot=web --php-version=8.3 --corepack-enable
        ddev add-on get ddev/ddev-drupal-contrib
        ddev start

4.  Install composer dependencies.

        ddev poser

    Note: `ddev poser` is shorthand for `ddev composer` to add in Drupal core dependencies
    without needing to modify the root composer.json. Find out more in Ddev Drupal Contrib
    [commands].

5.  Detect expected Drupal and PHP versions

         ddev config --update

6.  Install Drupal.

        ddev drush site:install

7.  Visit site in browser.

        ddev describe

    Or, login as user 1:

        ddev drush uli

8.  Push work to Merge Requests (MRs) opened via this project's [issue queue].


CHANGING DRUPAL CORE VERSION
----------------------------

Ddev Drupal Contrib installs a recent stable version of Drupal core via the `DRUPAL_CORE`
environment variable. Review .ddev/config.yaml to find the current default version.

Override the current default version of Drupal core by creating `.ddev/config.local.yaml`:

```yaml
web_environment:
    - DRUPAL_CORE=^11
```

After updating that value run `ddev restart`.

Enabling and using Xdebug
---------------------

Follow these steps to enable and use Xdebug with ddev.

1.  Create a local `.env` file by copying the example `.env.copy-me` file in `.ddev`.

        cp .ddev/.env.copy-me .ddev/.env

2.  Restart ddev and then enable Xdebug

        ddev restart
        ddev xdebug on

3.  Follow Xdebug configuration steps for your editor and browser.

UPDATING DEPENDENCIES
---------------------

This project depends on 3rd party PHP libraries. It also specifies suggested "dev dependencies"
for contribution on local development environments. Occasionally, Ddev and Ddev Drupal Contrib
must be updated as well.

1.  ddev config --update
2.  ddev add-on get ddev/ddev-drupal-contrib
3.  ddev restart
4.  Review and update PHP dependencies defined in composer.json

        ddev composer outdated --direct

[Ddev]: https://www.ddev.com/
[Ddev Drupal Contrib]: https://github.com/ddev/ddev-drupal-contrib
[Install Ddev]: https://ddev.readthedocs.io/en/stable/
[Docker provider]: https://ddev.readthedocs.io/en/stable/users/install/docker-installation/
[issue queue]: https://www.drupal.org/project/issues/tragedy_commons
[commands]: https://github.com/ddev/ddev-drupal-contrib#commands
